/*
  renderer.cpp
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>

#define GLEW_STATIC 1
#include <GL/glew.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "Simpletex.h"

using namespace std;

static GLint win = 0;
Simpletex *simpletex;
const int screenWidth = 500;
const int screenHeight = 500;
float mvMatrix[4][4];   //model-view matrix
float mvpMatrix[4][4];  //model-view projection matrix
float previousX=0,  previousY=0, dx = 0, dy = 0;
float angle = 0;        //rotaion angle due to mouse motion
float previousTime = 0; 
int anglex = 30, angley = 0, anglez = 0;    //roatation angles about x, y, z axis
float tx = 0, ty = 0, tz = 0;  //translations
float scale = 1;

int  init(void)
{
   const char *version;

   version = (const char *) glGetString(GL_VERSION);
   if (version[0] < '2' || version[1] != '.') {
      printf("This program requires OpenGL >= 2.x, found %s\n", version);
      exit(1);
   }
   glEnable (GL_CULL_FACE);
   glCullFace(GL_BACK); 
   int  loadStatus = 0;
   simpletex = new Simpletex( loadStatus );
   glLineWidth ( 3 );  
   glPointSize ( 3 );
   printf("\nDrag mouse or press 'x', 'X', 'y', 'Y', 'z', 'Z' to rotate object."); 
   printf("\nPress 'a', 'A', 'b', 'B', 'c', 'C' to translate object."); 
   printf("\nPress 'm', 'M' to scale object."); 
   printf("\nPress 't' to toggle object type.\n");

   return  loadStatus;
}

static void reshape(int width, int height)
{
   glViewport(0, 0, width, height);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glFrustum(-1.0, 1.0, -1.0, 1.0, 5.0, 25.0);
   glMatrixMode(GL_MODELVIEW);
}

void CleanUp(void)
{
   glutDestroyWindow(win);
}

static void idle(void)
{
   static float timeStep = 0;
   static bool  increase = true;
   float t = glutGet ( GLUT_ELAPSED_TIME );
   if ( t - previousTime  > 500.0 ){
     if ( timeStep > 0.91 ) 
	increase = false;
     else if ( timeStep < 0.09 )
        increase = true;
     if ( increase )
      timeStep += 0.1;
     else
      timeStep -= 0.1;
     simpletex->setTime ( timeStep );
     previousTime = t;
     glutPostRedisplay();
   } 
}


static void keyboard(unsigned char key, int x, int y)
{
   switch(key) {
   case 27:
      CleanUp();
      exit(0);
      break;
    case 'x':
      anglex = ( anglex + 3 ) % 360;
      break;
    case 'X':
      anglex = ( anglex - 3 ) % 360;
      break;
    case 'y':
      angley = ( angley + 3 ) % 360;
      break;
    case 'Y':
      angley = ( angley - 3 ) % 360;
      break;
    case 'z':
      anglez = ( anglez + 3 ) % 360;
      break;
    case 'Z':
      anglez = ( anglez - 3 ) % 360;
      break;
    case 'a':
      tx += 0.1;
      break;
    case 'A':
      tx -= 0.1;
      break;
    case 'b':
      ty += 0.1;
      break;
    case 'B':
      ty -= 0.1;
      break;
    case 'c':
      tz += 0.1;
      break;
    case 'C':
      tz -= 0.1;
      break;
    case 'm':
      scale *= 0.9;
      break;
    case 'M':
      scale *= 1.1;
      break;
    case 'r':
      anglex = angley = anglez = 0;  angle = 30;
      tx = ty = tz = 0.0;
      scale = 1.0;
      break;
    case 't':
      simpletex->setObjectType();
      break;
   }
   glutPostRedisplay();
}

void display(void)
{
   GLfloat vec[4];

   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   glClearColor( 1.0, 1.0, 1.0, 0.0 );	//get white background color

   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
   gluLookAt (0.0, 0.0, 18, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
   glTranslatef ( tx, ty, tz );           //translation
   glRotatef( angle, 1.0f, 0.2f, 0.2f );  //rotation due to mouse motion
   glRotatef( anglex, 1.0, 0.0, 0.0);                   //rotate the cube along x-axis
   glRotatef( angley, 0.0, 1.0, 0.0);                   //rotate along y-axis   
   glRotatef( anglez, 0.0, 0.0, 1.0);                   //rotate along z-axis 
   glScalef ( scale, scale, scale );     //scaling
   // retrieve model-view matrix
   glGetFloatv(GL_MODELVIEW_MATRIX, &mvMatrix[0][0]);

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   glFrustum(-1, 1, -1, 1, 5.0, 30.0);
   // multiply projection matrix by model-view matrix
   glMultMatrixf ( &mvMatrix[0][0] );
   // retrieve model-view projection matrix
   glGetFloatv(GL_PROJECTION_MATRIX, &mvpMatrix[0][0]);
   // pass transformation matrix to vertex shader
   simpletex->draw( mvpMatrix );
   simpletex->cleanUp();
   glutSwapBuffers();
   glFlush();
}


void movedMouse(  int mouseX, int mouseY)
{
  dx = mouseX - previousX;
  dy = mouseY - previousY;

  // reverse direction of rotation above the mid-line
  if (mouseY > screenHeight / 2)
     dx = dx * -1 ;
  // reverse direction of rotation to left of the mid-line
  if (mouseX < screenWidth / 2)
     dy = dy * -1 ;

  angle = angle + (dx + dy) / 2;  //scale factor of 2
  previousX = mouseX;
  previousY = mouseY;
  glutPostRedisplay();
}

int main(int argc, char *argv[])
{
   int success = 0;

   glutInit(&argc, argv);
   glutInitWindowPosition( 0, 0);
   glutInitWindowSize(screenWidth, screenHeight);
   glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH);
   win = glutCreateWindow(argv[0]);
   glutReshapeFunc(reshape);
   glutKeyboardFunc(keyboard);
   glutDisplayFunc(display);
   glutIdleFunc(idle);

   glutMotionFunc( movedMouse );

   // Initialize the "OpenGL Extension Wrangler" library
    glewInit();

   success = init();
   if ( success )
     glutMainLoop();
   else
     printf( "Initialization failed!\n");
   return 0;
}

