#ifndef _SIMPLETEX_H
#define _SIMPLETEX_H
#include "Shader.h"
#include <vector>

using namespace std;

class Simpletex : public Shader 
{
  private:
   static const string vsCode;    // Source code of vertex shader
   static const string fsCode ;   // Source code of fragment shader
   static const int COORDS_PER_VERTEX = 3;
   static const int iWidth = 64;  // Texture image widht
   static const int iHeight = 64; // Texture image height 
   GLubyte checkImage[iHeight][iWidth][3];
   void makeCheckImage(void);

   static const float figureA[][3];
   static const float figureB[][3];
   static const int Npoints = 9;  //number of points
   int timeHandle;
   unsigned texName;              //texture handle
   int objType;                   //Object type
  public:
   Simpletex( int &success );
   ~Simpletex();
   void init2DTexture();
   void draw( float mvpMatrix[4][4] );
   void setObjectType ();    
   void setTime ( float t );
};
#endif

