  // bump.frag: Source code of fragment shader

   varying vec4 lightVec;  //light direction vector in surface-local system
   varying vec4 eyeVec;    //eye direction vector in surface-local system  
   uniform sampler2D texHandle;
   void main()
   {
     vec3 litColor;
     vec3 n1;                //modulated normal
     n1 = texture2D(texHandle, gl_TexCoord[0].st).rgb;
     n1 = normalize ( n1 ); 
     vec3 surfaceColor = vec3 ( 1.0, 0.6, 0.2 );
     litColor = surfaceColor * max(dot(n1, lightVec.xyz), 0.0 );
     vec3 reflectVec = reflect ( lightVec.xyz, n1 );
     float specularLight = max ( dot(eyeVec.xyz, reflectVec), 0.0 );
     float specularFactor = 0.5;
     specularLight = pow ( specularLight, 6.0 ) * specularFactor;
     litColor = min ( litColor + specularLight, vec3(1.0) );

     gl_FragColor = vec4 ( litColor, 1.0 );
  }

