// Bump.cpp : class for rendering a color solid sphere
#include <math.h>
#include <GL/glew.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "Bump.h"
#include <stdio.h>
#include <vector>
#include <string>

using namespace std;
   
const float Bump::eyePos[] = {0, 0, 6.3, 1};
const float Bump::lightPos[] = {5, 10, 5, 1};
const float Bump::lightAmbi[] = {0.1, 0.1, 0.1, 1};
const float Bump::lightDiff[] = {1, 0.8, 0.6, 1};
const float Bump::lightSpec[] = {0.3, 0.2, 0.1, 1};
//material same for ambient, diffuse, and specular
const float Bump::materialColor[] = {1, 1, 1, 1};

// Create a Sphere object
Bump::Bump ( int  &success )
{
 string *vs, *fs;
  char *vsSource, *fsSource;

  // Read shader source code.
  readShaderFile( (char *) "bump.vert",  &vsSource);
  readShaderFile( (char *) "bump.frag",  &fsSource);
  vs = new string ( vsSource );
  fs = new string ( fsSource );
  success = createShader ( vs, fs );
  if ( !success ) {
    printf("infoLog:: %s\n", infoLog );
    return;
  }
  delete vs;       delete fs;
  delete vsSource; delete fsSource;

  createSphere (1.0f, N_SLICES, N_STACKS );
  int nVertices = vertices.size();
  int k = 0;
  int m = N_STACKS;
  int n = N_SLICES;

  nTriangles = 2 * n * (m - 1);    //number of triangles
  drawOrders = new short[3*nTriangles];
  for ( int j = 0; j < n; j++ )
  {
     for ( int i = 0; i < m-1; i++ ) {
       short j1 = (short)(j + 1);
       if ( j == n - 1 ) j1 = 0;   //wrap around
       short ia = (short)( j * m + i ) ;
       short ib = (short)( j * m + i + 1);
       short ic = (short) (j1 * m + i );
       short id = (short)( j1 * m + i + 1 );
       drawOrders[k++] = ia;
       drawOrders[k++] = ib;
       drawOrders[k++] = ic;
   
       drawOrders[k++] = ic;
       drawOrders[k++] = ib;
       drawOrders[k++] = id;
     }
  }

  sphereCoords = new float[3*nVertices];
  texCoords = new float[2*nVertices];
  k = 0;
  int kk = 0;
  for ( int i = 0; i < nVertices; i++ ) {
    XYZ v = vertices[i];
    sphereCoords[k++] = v.x;
    sphereCoords[k++] = v.y;
    sphereCoords[k++] = v.z;
    v = texPoints[i];
    texCoords[kk++] = v.x;
    texCoords[kk++] = v.y;
  }

  init2DTexture();
  objType = 0;

}

Bump::~Bump()
{
  while (vertices.size() > 0 )
    vertices.pop_back();
  while (texPoints.size() > 0 )
    texPoints.pop_back();
}

 void Bump::makeCheckImage(void)
 {
   int i, j, r, g;
   for (i = 0; i < iWidth; i++) {
      for (j = 0; j < iHeight; j++) {
        r = rand() % 32;
        g = rand() % 32;
        checkImage[i][j][0] = (GLubyte) r;
        checkImage[i][j][1] = (GLubyte) g;
        checkImage[i][j][2] = (GLubyte) 255;
      }
   }
 }
 
void Bump::init2DTexture()
{
  makeCheckImage();
  glGenTextures(1, &texName);
  glBindTexture(GL_TEXTURE_2D, texName);        //now we work on texName   
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, iWidth,
                iHeight, 0, GL_RGB, GL_UNSIGNED_BYTE, checkImage );
  glActiveTexture(GL_TEXTURE0);
  glBindTexture(GL_TEXTURE_2D, texName);
}
 
void Bump::createSphere ( float r, int nSlices, int nStacks )
{
     double phi,  theta;
     XYZ *p = new XYZ();
     XYZ *t = new XYZ();   //for texture coordinates
     const double PI = 3.1415926;
     const double TWOPI = 2 * PI;

     for ( int j = 0; j < nSlices; j++ ) {
       phi = j * TWOPI / (nSlices-1);   //0 to 2pi  (modified for texture)
       for ( int i = 0; i < nStacks; i++ ) {
         theta = i * PI / (nStacks-1);  //0 to pi
         p->x = r * (float) ( sin ( theta ) *  cos ( phi ));
         p->y = r * (float) ( sin ( theta ) *  sin ( phi ));
         p->z = r * (float)  cos ( theta );
         t->x = phi / TWOPI;   // s (column)
         t->y = 1 - theta / PI; // t (row)
         vertices.push_back ( *p  );
         texPoints.push_back ( *t );
       }
     }
}

void Bump::draw( float mvpMatrix[4][4] ) 
{
  // get handle to vertex shader's attribute variable vPosition
  int positionHandle= glGetAttribLocation(program,"vPosition");
  // Enable a handle to the sphere vertices
  glEnableVertexAttribArray( positionHandle );
  // Prepare the sphere coordinate data
  glVertexAttribPointer(positionHandle, COORDS_PER_VERTEX,
                           GL_FLOAT, false, 0, sphereCoords);
  
  // get handle to model-view projection matrix 
  int mvpMatrixHandle = glGetUniformLocation(program, "mvpMatrix");
  if (mvpMatrixHandle == -1)
     printf("No such uniform named %s\n", "mvpMatrix" );
  // pass model-view projection matrix to vertex shader
  glUniformMatrix4fv(mvpMatrixHandle, 1, GL_FALSE, &mvpMatrix[0][0] );

  int eyePosHandle = glGetUniformLocation(program, "eyePosition");
  int lightPosHandle = glGetUniformLocation(program, "lightPosition");
  int lightAmbiHandle = glGetUniformLocation(program, "lightAmbient");
  int lightDiffHandle = glGetUniformLocation(program, "lightDiffuse");
  int lightSpecHandle = glGetUniformLocation(program, "lightSpecular");
  int materialColorHandle = glGetUniformLocation(program, "materialColor");
  int shininessHandle =  glGetUniformLocation(program, "shininess");
  glUniform4fv(eyePosHandle, 1, eyePos);
  glUniform4fv(lightPosHandle, 1, lightPos);
  glUniform4fv(lightAmbiHandle, 1, lightAmbi);
  glUniform4fv(lightDiffHandle, 1, lightDiff);
  glUniform4fv(lightSpecHandle, 1, lightSpec);
  glUniform1f(shininessHandle, shininess);
  glUniform4fv(materialColorHandle, 1, materialColor);

  glEnable ( GL_TEXTURE_2D );
  glBindTexture(GL_TEXTURE_2D, texName);

  glEnableClientState (GL_TEXTURE_COORD_ARRAY);
  glTexCoordPointer ( 2, GL_FLOAT, 0, texCoords );
  // Draw all triangles
  for ( int i = 0; i < nTriangles; i++ ) 
    glDrawElements( GL_TRIANGLES, 3,
                          GL_UNSIGNED_SHORT, (drawOrders + i*3 )); 

  glDisableVertexAttribArray(positionHandle);
}

