   // Source code of vertex shader
   uniform mat4 mvpMatrix;
   attribute vec4 vPosition;
   uniform vec4 eyePosition;
   uniform vec4 lightPosition;

   varying vec3 N; //normal direction
   varying vec3 L; //light source direction
   varying vec3 V; //view vector
   varying vec4 lightVec;  //light vector
   varying vec4 eyeVec;    //eye vector
   void main()
   {
   //   N = vPosition.xyz;   //normal of  a point on sphere
      vec4 O = vec4 ( 0.0, 0.0, 0.0, 1 );   //origin
      N = normalize ( gl_Normal );
      L = lightPosition.xyz - vPosition.xyz;
      V = eyePosition.xyz - vPosition.xyz;

      //--------------------------
      vec3 n = normalize ( gl_Normal );  //normalized normal
      vec3 t;               //tangent
      //tangent for sphere
      if ( n.z < 1.0 && n.z > -1.0  ) 
      {
        t.x = -n.y;        //t perp to n; should be from application
        t.y = n.x;
      }   else {
        t.x = 0.0;
        t.y = 1.0;
      }
      t.z = 0.0;
      vec3 b = cross ( n, t );
      mat4 M = mat4(  vec4 (t, 0.0), vec4( n, 0.0), vec4(b, 0.0), vPosition );
      lightVec = normalize ( M * ( lightPosition - O ) );
   //   lightVec = normalize ( lightVec );
      eyeVec = normalize( M * ( eyePosition - O ) );
    //  eyeVec = normalize ( eyeVec );
      gl_TexCoord[0] = gl_MultiTexCoord0;
     //------------------------------------
      gl_Position = mvpMatrix * vPosition;
   }

