   // bump.vert: Source code of vertex shader
   uniform mat4 mvpMatrix;
   attribute vec4 vPosition;
   uniform vec4 eyePosition;
   uniform vec4 lightPosition;

   varying vec4 lightVec;  //light direction vector
   varying vec4 eyeVec;    //eye direction vector
   void main()
   {
      vec4 O = vec4 ( 0.0, 0.0, 0.0, 1 );   //origin
    
      // Normalized normal in object coordinates
      // Normal can be also obtained by: 
      //  vec3 n = normalize ( gl_NormalMatrix * gl_Normal );     
      vec3 n = normalize(vPosition.xyz - O.xyz);
      vec3 t;                //tangent
      //tangent for sphere (usually from application)
      if ( n.z < 1.0 && n.z > -1.0  ) 
      {
        t.x = -n.y;         //t perpendicular to n; 
        t.y = n.x;
      }   else {
        t.x = 0.0;          //special treatment at poles
        t.y = 1.0;
      }
      t.z = 0.0;
      vec3 b = cross(n, t); //binormal
      //Since n is normalized, so b and t are also normalized

      //Transformation matrix, which transforms object 
      //  to surface-local system (t, b, n)
      mat4 M = mat4(vec4 (t,vPosition.x), vec4(b,vPosition.y), 
		vec4(n,vPosition.z), vec4(0.0,0.0,0.0,1.0) );

      //light direction vector in surface-local system 
      lightVec = normalize ( M * ( lightPosition - vPosition ) );

      //eye direction vector in surface-local system
      eyeVec = normalize( M * ( eyePosition - vPosition ) );

      //texture coordinates for fragment shader
      gl_TexCoord[0] = gl_MultiTexCoord0;

      gl_Position = mvpMatrix * vPosition;
   }

