  // bump.frag: Source code of fragment shader

   varying vec4 lightVec;  //light direction vector in surface-local system
   varying vec4 eyeVec;    //eye direction vector in surface-local system  
   void main()
   {
     float bumpDensity = 10.0;
     float bumpSize = 0.1;   
     vec3 litColor;
     vec2 c = bumpDensity * gl_TexCoord[0].st;	
     vec2 b = fract( c ) - vec2(0.5, 0.5); //a texsel on surface
     vec3 n1;                //modulated normal

     float r2;               //square of radius of bump
     r2 = b.x * b.x + b.y * b.y;

     if ( r2 <= bumpSize ) { //modulate normal
       n1 = vec3 ( b, 1.0 ); //n1.z = 1
       n1 = normalize ( n1 );
     } else                  //do not perturb normal
       n1 = vec3 ( 0, 0, 1 );    

     vec3 surfaceColor = vec3 ( 1.0, 0.6, 0.2 );
     litColor = surfaceColor * max(dot(n1, lightVec.xyz), 0.0 );
     vec3 reflectVec = reflect ( lightVec.xyz, n1 );
     float specularLight = max ( dot(eyeVec.xyz, reflectVec), 0.0 );
     float specularFactor = 0.5;
     specularLight = pow ( specularLight, 6.0 ) * specularFactor;
     litColor = min ( litColor + specularLight, vec3(1.0) );

     gl_FragColor = vec4 ( litColor, 1.0 );
  }

