// Tetrahedrons.cpp (rendering color solid tetrahedrons) 
#include <string>
#include <GL/glew.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "Tetrahedrons.h"
#include <stdio.h>

using namespace std;
  
//  Coordinates of a tetrahedron 
const float Tetrahedrons::tetraCoords[] =
{
   1.0f, 0.0f, -0.707f, // vertex v0
  -1.0f, 0.0f, -0.707f, // v1
   0.0f, 1.0f,  0.707f, // v2
   0.0f, -1.0f, 0.707f  // v3
};
    
// draw order for each face
const short Tetrahedrons::drawOrders[][3] = {
   {0, 1, 2},  {0, 2, 3},  {0, 3, 1},  {3, 2, 1}
};

// color for each face
const float Tetrahedrons::colors[][4] = {
    {1.0f, 0.0f, 0.0f, 1.0f},   // 0,1, 2 red
    {0.0f, 1.0f, 0.0f, 1.0f},   // 0, 2, 3 green
    {0.0f, 0.0f, 1.0f, 1.0f},   // 0, 3, 1 blue
    {1.0f, 1.0f, 0.0f, 1.0f}    // 3, 2, 1 yellow
};

// Create a Tetrahedron object
Tetrahedrons::Tetrahedrons ( int  &success )
{
  string *vs, *fs;
  char *vsSource, *fsSource;

  // Read shader source code.
  readShaderFile( (char *) "tetra.vert",  &vsSource); 
  readShaderFile( (char *)"tetra.frag",  &fsSource); 
  vs = new string ( vsSource );
  fs = new string ( fsSource );
  success = createShader ( vs, fs );
  if ( !success ) {
    printf("infoLog: %s\n", infoLog );
    return;
  }
  delete vs;       delete fs;
  delete vsSource; delete fsSource;
}

void Tetrahedrons::draw( float mvpMatrix[4][4] ) 
{
  // get handle to vertex shader's attribute variable vPosition
  int positionHandle = glGetAttribLocation(program,"vPosition");
  // Enable a handle to the tetrahedron vertices
  glEnableVertexAttribArray( positionHandle );

  // Prepare the tetrahedron coordinate data
  glVertexAttribPointer(positionHandle, COORDS_PER_VERTEX,
                           GL_FLOAT, false, 0, tetraCoords);
  
  int mvpMatrixHandle = glGetUniformLocation(program, "mvpMatrix");
  if (mvpMatrixHandle == -1) 
     printf("No such uniform named %s\n", "mvpMatrix" );
  glUniformMatrix4fv(mvpMatrixHandle, 1, GL_FALSE, &mvpMatrix[0][0] );

  int colorHandle  =  glGetUniformLocation(program, "vColor");
  if (colorHandle == -1) 
     printf("No such uniform named %s\n", "vColor" );
  glEnable (GL_CULL_FACE);
  glCullFace(GL_BACK);
  for ( int i = 0; i < N_FACES; i++ ) {
    glUniform4fv(colorHandle, 1, &colors[i][0]);  
    glDrawElements( GL_TRIANGLES, 3,
                              GL_UNSIGNED_SHORT, &drawOrders[i][0]);   
  }
  // Disable vertex array
  glDisableVertexAttribArray(positionHandle);
}
