// Tetrahedron.cpp 
#include <string>
#include <GL/glew.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "Tetrahedron.h"
#include <stdio.h>

using namespace std;
  
//  Coordinates of a tetrahedron 
const float Tetrahedron::tetraCoords[] =
{
  1, 0, -0.707f,  -1, 0, -0.707f,
  0, 1,  0.707f,   0, -1, 0.707f
};
    
const int nIndices = 8;  // number of indices
// Order of indices of drawing the tetrahedron
const short indices[nIndices] = { 0, 1, 2, 0, 3, 1, 2, 3 };

// Create a Tetrahedron object
Tetrahedron::Tetrahedron ( int  &success )
{
  string *vs, *fs;
  char *vsSource, *fsSource;

  // Read shader source code.
  readShaderFile( (char *) "tetra.vert",  &vsSource); 
  readShaderFile( (char *)"tetra.frag",  &fsSource); 
  vs = new string ( vsSource );
  fs = new string ( fsSource );
  success = createShader ( vs, fs );
  if ( !success ) {
    printf("infoLog: %s\n", infoLog );
    return;
  }
  delete vs;       delete fs;
  delete vsSource; delete fsSource;
}

void Tetrahedron::draw() 
{
  // get handle to vertex shader's attribute variable vPosition
  int positionHandle= glGetAttribLocation(program,"vPosition");

  // Enable a handle to the tetrahedron vertices
  glEnableVertexAttribArray( positionHandle );

  // Prepare the tetrahedron coordinate data
  glVertexAttribPointer(positionHandle, COORDS_PER_VERTEX,
                           GL_FLOAT, false, 0, tetraCoords);

  int colorHandle  =  glGetUniformLocation(program, "vColor");
  if (colorHandle == -1) 
      printf("No such uniform named %s\n", "vColor" );
 
  // set color
  glUniform4f ( colorHandle, 0.0, 1.0, 1.0, 1.0 );
  glLineWidth(5);
  // Draw the tetrahedron
  glDrawElements( GL_LINE_STRIP, nIndices,
                              GL_UNSIGNED_SHORT, indices);   

  // Disable vertex array
  glDisableVertexAttribArray(positionHandle);
}
