// Square.cpp (constructing temperature shader)
#include <string>
#include <GL/glew.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "Square.h"
#include <stdio.h>

using namespace std;
  
//  Coordinates of a square 
const float Square::squareCoords[] =
{  // in counterclockwise order:
   -0.8f,  0.8f, 0.0f,  // top left vertex
   -0.8f, -0.8f, 0.0f,  // bottom left
    0.8f, -0.8f, 0.0f,  // bottom right
    0.8f,  0.8f, 0.0f   // upper right
};
    
// Temperature at each vertex
const float Square::vertexTemp[] = {
    5.0f,              // v0 cold (top left)
    12.0f,             // v1 cool
    22.0f,             // v2 warm
    40.0f              // v3 hot (upper right)
};

// Create a Square object
Square::Square ( int  &success )
{
  string *vs, *fs;
  char *vsSource = NULL, *fsSource = NULL;

  // Read shader source code.
  readShaderFile( (char *) "temp.vert",  &vsSource); 
  readShaderFile( (char *) "temp.frag",  &fsSource); 
  vs = new string ( vsSource );
  fs = new string ( fsSource );
  success = createShader ( vs, fs );
  if ( !success ) {
    printf("infoLog: %s\n", infoLog );
    return;
  }
  delete vs;       delete fs;
  delete vsSource; delete fsSource;
}

void Square::draw() 
{
  // get handle to vertex shader's attribute variable vPosition
  int positionHandle= glGetAttribLocation(program,"vPosition");
  int vertexTempHandle= glGetAttribLocation(program,"vertexTemp");

  // Enable a handle to the square vertices
  glEnableVertexAttribArray( positionHandle );

  // Prepare the square coordinate data
  glVertexAttribPointer(positionHandle, COORDS_PER_VERTEX,
                           GL_FLOAT, false, 0, squareCoords);
  glEnableVertexAttribArray( positionHandle );
  
  // Enable a handle to the temperatures at vertices
  glEnableVertexAttribArray( vertexTempHandle );
  // Pointing to the vertex temperatures
  glVertexAttribPointer (vertexTempHandle, 1, 
                           GL_FLOAT, false, 0, vertexTemp); 

  GLchar names[][20] = { "coldColor", "hotColor", "tempRange" };
  GLint handles[10];
  for ( int i = 0; i < 3; ++i ) {
    handles[i] =  glGetUniformLocation(program, names[i]);
    if (handles[i] == -1) 
      printf("No such uniform named %s\n", names[i]);
  }
  
  // set uniform values  
  glUniform3f(handles[0], 0.0, 0.0, 1);   //cold color
  glUniform3f(handles[1], 1.0, 0.0, 0.0); //hot color
  glUniform1f(handles[2], 50.0);          //temperature range

  // Draw the square
  glDrawArrays( GL_QUADS, 0, vertexCount);
      
  // Disable vertex array
  glDisableVertexAttribArray(positionHandle);
  glDisableVertexAttribArray(vertexTempHandle);
}
