#ifndef _PARTICLES_H
#define _PARTICLES_H
#include "Shader.h"
#include <vector>

using namespace std;

class ColorPoint{
public:
  float position[4];
  float color[4];
  ColorPoint ( float position0[], float color0[] ) {  // constructor
    for ( int i = 0; i < 4; i++ ) {
      position[i] = position0[i];
      color[i] = color0[i];
    }
  }  
};

class Particles : public Shader 
{
  private:
   static const string vsCode;   // Source code of vertex shader
   static const string fsCode ;  // Source code of fragment shader
   static const int COORDS_PER_VERTEX = 3;
   static const int Npoints = 2000;    //number of points to be created
   vector<ColorPoint> pointArray;     //queue holding points
   int timeHandle;

  public:
   Particles( int &success );
   ~Particles();
   void draw( float mvpMatrix[4][4] );
   void setTime ( float t );
};
#endif

