#include <math.h>
#include <GL/glew.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include "Particles.h"
#include <stdio.h>
#include <vector>
#include <string>

using namespace std;
   
// Create a Sphere object
Particles::Particles ( int  &success )
{
 string *vs, *fs;
  char *vsSource, *fsSource;

  // Read shader source code.
  readShaderFile( (char *) "particles.vert",  &vsSource);
  readShaderFile( (char *) "particles.frag",  &fsSource);
  vs = new string ( vsSource );
  fs = new string ( fsSource );
  success = createShader ( vs, fs );
  if ( !success ) {
    printf("infoLog: %s\n", infoLog );
    return;
  }
  delete vs;       delete fs;
  delete vsSource; delete fsSource;

  //create Npoints particles 
  float position[4];
  float color[4];
  for ( int i = 0; i < Npoints; ++i ){
    for ( int j = 0; j < 3; j++ ) {
      position[j] = (float) ( rand () % 32000 ) / 16000.0 - 1.0; //-1 --> 1
      color[j] = (float) ( rand() % 32000 ) / 32000.0;  //0 --> 1
    }
    color[3] = position[3] = 1;  //not used
    ColorPoint cp = ColorPoint ( position, color );
    pointArray.push_back ( cp );            //put into vector
  }
}

Particles::~Particles()
{
  while ( pointArray.size() > 0 )
    pointArray.pop_back();
}
  
void Particles::draw( float mvpMatrix[4][4] ) 
{
  // get handle to vertex shader's attribute variable vPosition
  int positionHandle= glGetAttribLocation(program,"vPosition");
  int mvpMatrixHandle = glGetUniformLocation(program, "mvpMatrix");
  if (mvpMatrixHandle == -1)
     printf("No such uniform named %s\n", "mvpMatrix" );
  // pass model-view projection matrix to vertex shader
  glUniformMatrix4fv(mvpMatrixHandle, 1, GL_FALSE, &mvpMatrix[0][0] );

  // get handle to fragment shader's uniform variable vColor
  int colorHandle =  glGetUniformLocation(program, "vColor");
  if ( colorHandle == -1 )
    printf("No such uniform named vColor\n");
  timeHandle =  glGetUniformLocation(program, "timeLapsed");
  if ( timeHandle == -1 )
    printf("No such uniform named timeLapsed\n");
  
  ColorPoint *cp;
  for ( int i = 0; i < Npoints; i++ ) {
    cp = &pointArray[i];
    glUniform4fv(colorHandle, 1, cp->color);
    glBegin ( GL_POINTS );
      glVertex4fv ( cp->position );
    glEnd();  
  }
}

void Particles::setTime ( float t )
{
  glUniform1f ( timeHandle, t );   // send the lapsed time to vertex shader
}
