/*
 * RunHuff.java
 * For the use of constructing a pre-calculated Huffman tree.
 */

/*
 * Need to implement Comparable so that a RunHuff object
 * can be inserted into a TreeMap which contains the
 * Huffman Table used for encoding.
 */
class RunHuff implements Comparable<RunHuff> 
{
  Run3D r = new Run3D();
  int codeword;
  byte hlen;		//length of Huffman code
  short index;		//table index where codeword saved
  
  RunHuff() {}		//constructors
  
  RunHuff ( Run3D a, int c, byte len, short idx ) 
  { 
    r.run = a.run; r.level = a.level; r.last = a.last; 
    codeword = c; hlen = len; index = idx; 
  }

  //A run tuple is used as a key for comparison
  public int compareTo ( RunHuff right ) throws ClassCastException
  {
    if ( r.run < right.r.run )
      return 1;
    if ( r.run > right.r.run )
      return -1;
    //run equals
    if ( r.level < right.r.level )
      return 1;          
    if ( r.level > right.r.level )
      return -1;
   //both run and level equal
    if ( r.last < right.r.last )
      return 1;
    if ( r.last > right.r.last )
      return -1;	
    return 0;		 	//The two objects equal
  }
};

