/*
 *  Dtables.java
 *  Class Dtables has an array of short to hold a Huffman tree, and
 *  and array of Run3D to hold the 3D run-level codewoards.  
 *  Run3D class is defined in ../7.
 */
class Dtables {
  short huf_tree[] = new short[1024];   //table containing Huffman Tree
  Run3D run_table[] = new Run3D[512];   //table containing run-level codewords

  Dtables()
  {
    for ( int i = 0; i < 512; i++ )
      run_table[i] = new Run3D();
  }

  void print_Dtables( int N )
  {
    int i, j, k, n0, ntotal, root;
    n0 = 256;                        //number of symbols ( = number of leaves in tree )
    ntotal = 2 * n0 - 1;                  //Huffman tree has  n0 - 1  internal nodes 
    root = 3 * n0 - 3;
    System.out.printf("\nDtables: N=%d", N );
    System.out.printf("\nhuff_tree \tloc" );
    j = root - n0;
    for ( i = 0; i < 2*N; ++i ) {
      k = huf_tree[j];
      if ( k > n0 ) k -= n0;
      System.out.printf("\n%d        \t%d", k, j );
      if ( k < n0 && k > -1 )
        System.out.printf(" \t(%d \t%d \t%d)", run_table[k].run, run_table[k].level, run_table[k].last );
      j--;
    }
  }
}
