/*
 * Quantizer.java
 * Hard-code quantization step to 12.
 * Consists of forward and inverse quantizer.
 * Has made slight modifications to  Java round. ( See Section 5.2 of 
 *   Chapter 5 of ``An Introduction to Digital Video Data Compression
 *   in Java" by Fore June. )
 */

class Quantizer {

  short Qstep = 12;

  //forward quantizer
  void quantize_block ( short [][]  coef )
  {
    double x;
    for ( int i = 0; i < 8; i++ )
      for ( int j = 0; j < 8; j++ ){
        x =  (double)coef[i][j] / Qstep;
        if ( x == -0.5 )
 	  x = -0.6;		//we want round(x) = -1, when x = -0.5
        else if ( x == -1.5 )
	  x = -1.6;		//we want round(x) = -2, when x = -1.6
        else if ( x == -2.5 )
          x = -2.6;
	else if ( x == -3.5 )
	  x = -3.6;

        coef[i][j] = ( short ) Math.round ( x );
      }
  }

  //inverse quantize one block 
  void inverse_quantize_block ( short [][] coef )
  {
    for ( int i = 0; i < 8; i++ )
      for ( int j = 0; j < 8; j++ )
        coef[i][j] = (short) (  coef[i][j] * Qstep );
  }
}

