/*
  Test_dct.java
  For testing dct() and idct() routines in DctVideo.java.
  Compile: javac Test_dct.java
  Execute: java Test_dct
*/

public class Test_dct {
  //print one 8x8 sample block
  static void print_block( int [][] X )
  {
    for ( int i = 0; i < 8; ++i ){
      System.out.printf("\n");
      for ( int j = 0; j < 8; ++j ) {
        System.out.printf("%4d, ", X[i][j] );
      }
    }
  }
	
  public static void main(String[] args) throws InterruptedException
  {
    int [][] X = new int[8][8], Y = new int[8][8];
    int i, j;
  
    //some sample data
    for ( i = 0; i < 8; ++i ) 
      for ( j = 0; j < 8; ++j ) 
        X[i][j] =  3 * i *j  + j + 1 ;
  
    System.out.printf("\nOriginal Data:");
    System.out.printf("\n ------------------");
    print_block ( X );

    DctVideo dct_idct = new DctVideo();

    dct_idct.dct(  X,  Y );

    System.out.printf("\n\nData after dct:");
    print_block ( Y );

    dct_idct.idct ( Y, X );                                                                             
  
    System.out.printf("\n\nData recovered by idct:");
    System.out.printf("\n ------------------");
    print_block ( X );
    System.out.printf("\n");
  }
}

