/* common.java
 * Classes defined in this file will be commonly used in
 * subsequent chapters.
 */

//defines an RGB pixel
class RGB {
  int R;      //0 - 255
  int G;      //0 - 255
  int B;      //0 - 255
  RGB () {
    R = G = B = 0;
  }
}

class YCbCr {
  int Y;      //0 - 255
  int Cb;     //0 - 255
  int Cr;     //0 - 255
  YCbCr() {
    Y = Cb = Cr = 0;
  }
}

//16x16 RGB block
class RGB_MACRO {
  RGB [] rgb;
  RGB_MACRO(){  //constructor
    rgb = new RGB[256];
    //allocate memory
    for ( int i = 0; i < 256; ++i )
      rgb[i] = new RGB();
  } 
}

//4:2:0 YCbCr Macroblock
class YCbCr_MACRO {
  int [] Y = new int[256];  //16x16 (four 8x8 samples)
  int [] Cb  = new int[64]; //8x8
  int [] Cr  = new int[64]; //8x8
}

//for holding difference macroblocks
class Diff_MACRO {
  int [] Y = new int[256];
  int [] Cb = new int[64];
  int [] Cr = new int[64];
}

class RGBImage {
  int width;                  //image width
  int height;                 //image height	
  RGB  [] ibuf;
  //constructor
  RGBImage ( int w, int h )
  {
    width = w;
    height = h;
    ibuf = new RGB[width*height];//image data buffer
    for ( int i = 0; i < width * height; ++i )
      ibuf[i] = new RGB();
  }
}
