/*
  Ppmdemo.java
  PPM files may either have ASCII or raw (binary) data. 
  The decoder automatically determines the data format 
  and reads the data accordingly. By default the encoder 
  stores the image data in raw format whenever possible.
  No error checking here.
*/
import java.io.*;
import java.awt.Frame;
import java.awt.image.*;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import com.sun.media.jai.codec.FileSeekableStream;
import javax.media.jai.widget.ScrollingImagePanel;
import com.sun.media.jai.codec.PNMEncodeParam;

public class Ppmdemo {
 
  public static void main(String[] args) throws InterruptedException {
    if (args.length != 1) {
      System.out.println("Usage: java " + "Ppmdemo " +
                                    "input_image_filename");
      System.exit(-1);
    }

    /*
     * Create an input stream from the specified file name
     * to be used with the file decoding operator.
     */
     FileSeekableStream stream = null;
     try {
       stream = new FileSeekableStream(args[0]);
     } catch (IOException e) {
       e.printStackTrace();
       System.exit(0);
     }
  
    //First we demonstrate the reading of pnm data

    /* Create an operator to decode the image file. */
    RenderedOp image1 = JAI.create("stream", stream);

    /* Get the width and height of image. */
    int width = image1.getWidth();
    int height = image1.getHeight();

    //allocate array to hold RGB data
    int [] samples = new int[3*width*height];      
    
    Raster ras = image1.getData();
    //save pixel RGB data in samples[]
    ras.getPixels( 0, 0, width, height, samples ); 

    System.out.printf("Image width=%d, height=%d\n", width, height );
    
    /* Attach image1 to a scrolling panel to be displayed. */
    ScrollingImagePanel panel = new ScrollingImagePanel( image1, width, height );

    /* Create a frame to contain the panel. */
    Frame window = new Frame("Displaying PPM Data");
    window.add(panel);
    window.pack();
    window.show();
    Thread.sleep( 2000 ); //sleep for two seconds
    window.dispose();     //close the frame

   //now, we demonstrate the writing of ppm data
    String filename = "testwrite.ppm";
    
    try {
      File f = new File ( filename );
      OutputStream out = new FileOutputStream( f );

      //First write PPM header.
      byte [] P6 = { 'P', '6', '\n' };
      out.write ( P6 );
      String s = Integer.toString ( width );
      for ( int i = 0; i < s.length(); ++i )  //write the width 
        out.write ( s.charAt(i) );           
      out.write ( ' ' );
      s = Integer.toString ( height );  
      for ( int i = 0; i < s.length(); ++i )   //write the height
        out.write ( s.charAt(i) );
      out.write ( '\n' );
      //write color levels
      byte [] colorLevels = { '2', '5', '5', '\n' };
      out.write ( colorLevels );
      
      int size = 3 * width * height;
      byte [] bytes = new byte[size];
      //save the image data
      for ( int i = 0; i < size; i += 1 ){
         bytes[i] = (byte) samples[i];
      }
      out.write ( bytes );
      out.close();
    } catch (IOException e) {
       e.printStackTrace();
       System.exit(0);
    }
    System.out.println("PPM Data written to 'testwrite.ppm'! Test using 'xview testwrite.ppm'." );
  }
}

