/*  Rgbyccf.java
 *  Program to demonstrate the conversions between RGB and YCbCr 
 *  using ITU standard coefficients.
 *  Floating point arithmetic is used.
 *  Compile: $javac rgbyccf.java
 *  Execute: $java  rgbyccf
 */

import java.io.*;

class Rgbyccf {
  public static void main(String[] args) {
    //0 <= R, G, B <= 1, sample values 
    double R = 0.3, G = 0.7, B = 0.2, Y, Cb, Cr;
    System.out.printf("\nOriginal R, G, B:\t%f, %f, %f", R, G, B );
    
    Y  = 0.299 * R + 0.587 * G + 0.114 * B;
    Cb = 0.564 * (B - Y) + 0.5;
    Cr = 0.713 * (R - Y) + 0.5;
    System.out.printf("\nConverted Y, Cb, Cr:\t%f, %f, %f", Y, Cb, Cr );  

    //recovering R, G, B
    R = Y + 1.402 * Cr - 0.701;
    G = Y - 0.714 * Cr - 0.344 * Cb  + 0.529;
    B = Y + 1.772 * Cb - 0.886;
    System.out.printf("\nRecovered R, G, B:\t%f, %f, %f\n\n", R, G, B );
  }
}
