//Vec2.java: class defining two-dimensional vectors

class Vec2 {
  public int x;
  public int y;

  //constructors
  public Vec2 ()
  {
    x = y = 0;
  }

  public Vec2 ( int x0, int y0 )
  {
    x = x0;    y = y0;
  }

  public Vec2 ( Vec2 v )
  {
    x = v.x;
    y = v.y;
  }

  public void set ( int x0, int y0 )
  {
    x = x0;    y = y0;
  }

  public void set ( Vec2 v )
  {
    x = v.x;
    y = v.y;
  }

  //negation of this vector
  public void neg ()
  {
    x = -x;
    y = -y;
  }

  //vector - vector --> vector
  public Vec2 minus ( Vec2 v )
  {
    Vec2 v1 = new Vec2();

    v1.x = x - v.x;
    v1.y = y - v.y; 

    return v1;
  }

  //vector + vector --> vector
  public Vec2 plus ( Vec2 v )
  {
    Vec2 v1 = new Vec2();

    v1.x = x + v.x;
    v1.y = y + v.y;

    return v1; 
  }
 
  //vector + point --> point
  public Point2 plus ( Point2 p )
  {
    Point2 p1 = new Point2();

    p1.x = x + p.x;
    p1.y = y + p.y;

    return p1; 
  }
   
}

