//Point2.java: class defining two-dimensional points

class Point2 {
  public int x;
  public int y;

  //constructors
  public Point2 ()
  {
    x = y = 0;
  }

  public Point2 ( int x0, int y0 )
  {
    x = x0;    y = y0;
  }

  public Point2 ( Point2 p )
  {
    x = p.x;
    y = p.y;
  }

  public void set ( int x0, int y0 )
  {
    x = x0;    y = y0;
  }

  public void set ( Point2 p )
  {
    x = p.x;    y = p.y;
  }

  //point - point --> vector
  public Vec2 minus ( Point2 p )
  {
    Vec2 v = new Vec2();

    v.x = x - p.x;
    v.y = y - p.y;

    return v;
  }

  //point - vector --> point
  public Point2 minus ( Vec2 v )
  {
    Point2 p = new Point2();

    p.x = x - v.x;
    p.y = y - v.y;

    return p;
  }

  //point + vector --> point
  public Point2 plus ( Vec2 v )
  {
    Point2 p = new Point2();

    p.x = x + v.x;
    p.y = y + v.y;

    return p;
  }
}

