/*
 * MvHuff.java
 * For the use of constructing a pre-calculated Huffman tree for MV vectors.
 */

/*
 * Need to implement Comparable so that a MvHuff object
 * can be inserted into a TreeMap which will contain the
 * Huffman Table used for encoding.
 */
class MvHuff implements Comparable<MvHuff> 
{
  Vec2 mv;
  int codeword;
  byte hlen;		//length of Huffman code
  short index;		//table index where codeword saved
  
  MvHuff()              //constructors
  {
    mv = new Vec2();
  }
  
  MvHuff ( Vec2 a, int c, byte len, short idx ) 
  { 
    mv = a; 
    codeword = c; hlen = len; index = idx; 
  }

  //A Vec2 is used as a key for comparison
  public int compareTo ( MvHuff right ) throws ClassCastException
  {
    if ( mv.x < right.mv.x )
      return 1;
    if ( mv.x > right.mv.x )
      return -1;
    //x equals
    if ( mv.y < right.mv.y )
      return 1;          
    if ( mv.y > right.mv.y )
      return -1;
    //both x and y values equal
    return 0;		 	//The two objects equal
  }
}

class MVtables 
{
  public short mv_tree[];       //table containing Huffman Tree for MVs
  public Vec2  mv_table[];      //table containing MVs 

  public MVtables()
  {
    mv_tree = new short[1024];
    mv_table = new Vec2[512];
    for ( int i = 0; i < 512; i++ )
      mv_table[i] = new Vec2();
  }
}
