/*
   Display.java
   This class is responsible for setting up a correct color and image model,
   getting image data from the head slot of the shared circular queue, and
   rendering the data on the screen.
*/
import java.io.*;
import java.awt.Frame;
import java.awt.image.*;
import java.awt.image.ColorModel;
import java.awt.color.ColorSpace;
import java.awt.*;
import javax.media.jai.widget.ScrollingImagePanel;
import javax.media.jai.*;

public class Display {
   private CircularQueue buf;
   private int height;
   private int width;
   private TiledImage outImage;
   private ScrollingImagePanel panel;  
   private Frame window;

   //constructor
   public Display ( CircularQueue q, int w, int h )
   {
      buf =q;
      width = w;
      height = h;

      //create a TiledImage using a ColorModel and a SampleModel 
      ColorSpace colorspace = ColorSpace.getInstance ( ColorSpace.CS_sRGB );
      int[] bits = { 8, 8, 8 };
      ColorModel  colormodel = new ComponentColorModel( colorspace, bits, 
        false, false, Transparency.OPAQUE, DataBuffer.TYPE_BYTE );
      SampleModel  samplemodel = new BandedSampleModel(DataBuffer.TYPE_BYTE,
                                                         width, height, 3);
      outImage = new TiledImage(0,0,width,height,0,0,samplemodel,colormodel);
      panel = new ScrollingImagePanel(outImage,width,height);
      window = new Frame("Player");
      window.add(panel);
      window.pack();
      window.show();
  }  

  public void display_frame()
  { 
    //render the  images 
    int h = buf.getHead(); 
    int k = 0;
    for (int y = 0; y < height; y++) {
      for (int x = 0; x < width; x++) {
        int c; 
        //consider colors R, G, B
        for ( int i = 0; i < 3; ++i ) {
          c = (int)( buf.buffer[h][k++] ); 
          outImage.setSample(x, y, i, c );
        }
      }
    }
    panel.set ( outImage );
  }

  public void close_window() 
  {
    window.dispose();     //close the frame
  }
}

