/*
 * AviProduceFrames.java
 * This class makes use of the ij plugin (ij.jar) to to get image data from
 * an AVI image stack and put them on the shared circular buffer.
 */

import ij.plugin.AVI_Reader;

//producer
class AviFrameProducer extends Thread {

  private AVI_Reader avi;
  private CircularQueue buf;

  //constructor
  public AviFrameProducer( AVI_Reader aviReader, CircularQueue q )
  {
    avi = aviReader;
    buf = q;
  }

  public void run()
  {
    int vsize = avi.getSize();     //number of images in the virtual stack
    int nFrame = 1;
    System.out.printf("Total number of frames in virtual stack = %d\n", vsize );
    while ( !buf.quit ) {
      buf.waitIfBufferFull();
      //produces data
      buf.putSamples ( avi, nFrame );  //put samples in buffer
      buf.tailInc();
      ++nFrame;
      if ( nFrame > vsize )
        buf.quit = true;
    }
  }
}
