/*
  RawPlayer.java
  Simple program for testing Player and Decoder which share
  a CircularQueue.  The height and width of an image frame
  are hard-coded ( 320 x 240 ).  It reads raw RGB video data 
  from a file that has saved the data in raw 8-bit format.
*/ 
import java.io.*;

public class RawPlayer 
{
  public static void main( String [] args )
  {
    if (args.length < 1) {
      System.out.println("Usage: java " + "RawPlayer" +
        " filename_of_raw_video_data\n" +
        "e.g. java RawPlayer ../data/jvideo.raw (the video data must be 320x240)"  );
      System.exit(-1);
    }

    //queue size, width, height
    CircularQueue sharedQueue = new CircularQueue( 4, 320, 240 );
    DataInputStream in;
    try {
      File f = new File ( args[0] );
      InputStream ins = new FileInputStream( f );
      in = new DataInputStream ( ins );
      //producer
      Decoder p = new Decoder( in, sharedQueue );
      p.start();		//start producer thread
    } catch (IOException e) {
       e.printStackTrace();
       System.exit(0);
    }

    //consumer
    Player c = new Player( sharedQueue );
    c.start();		//start consumer thread
  } //main
}

