/*
 * Decompiled with CFR 0.152.
 */
package mri.v3ds;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import mri.v3ds.Camera3ds;
import mri.v3ds.Decode3ds;
import mri.v3ds.Exception3ds;
import mri.v3ds.Face3ds;
import mri.v3ds.FaceMat3ds;
import mri.v3ds.HideKey3ds;
import mri.v3ds.HideTrack3ds;
import mri.v3ds.Material3ds;
import mri.v3ds.Mesh3ds;
import mri.v3ds.MorphKey3ds;
import mri.v3ds.MorphTrack3ds;
import mri.v3ds.PKey3ds;
import mri.v3ds.PTrack3ds;
import mri.v3ds.RotationKey3ds;
import mri.v3ds.RotationTrack3ds;
import mri.v3ds.SplineKey3ds;
import mri.v3ds.TexCoord3ds;
import mri.v3ds.TextDecode3ds;
import mri.v3ds.Track3ds;
import mri.v3ds.Utils3ds;
import mri.v3ds.Vertex3ds;
import mri.v3ds.XYZKey3ds;
import mri.v3ds.XYZTrack3ds;

public class Scene3ds {
    public static final int DECODE_ALL = 3;
    public static final int DECODE_USED_PARAMS = 2;
    public static final int DECODE_USED_PARAMS_AND_CHUNKS = 1;
    Vector mMesh = new Vector(5, 5);
    private Vector mCamera = new Vector(5, 5);
    private Vector mMaterial = new Vector(5, 5);
    int mStartFrame = 0;
    int mEndFrame = 0;
    private byte[] mFileData = null;
    private int mFileLength = 0;
    private int mFilePos = 0;
    private Decode3ds mDecode = null;
    static final int CHUNK_M3DMAGIC = 19789;
    static final int CHUNK_MDATA = 15677;
    static final int CHUNK_MAT_ENTRY = 45055;
    static final int CHUNK_MAT_NAME = 40960;
    static final int CHUNK_NAMED_OBJECT = 16384;
    static final int CHUNK_N_TRI_OBJECT = 16640;
    static final int CHUNK_POINT_ARRAY = 16656;
    static final int CHUNK_TEX_VERTS = 16704;
    static final int CHUNK_MESH_TEXTURE_INFO = 16752;
    static final int CHUNK_MESH_MATRIX = 16736;
    static final int CHUNK_MESH_COLOR = 16741;
    static final int CHUNK_FACE_ARRAY = 16672;
    static final int CHUNK_MSH_MAT_GROUP = 16688;
    static final int CHUNK_SMOOTH_GROUP = 16720;
    static final int CHUNK_N_CAMERA = 18176;
    static final int CHUNK_CAM_SEE_CONE = 18192;
    static final int CHUNK_CAM_RANGES = 18208;
    static final int CHUNK_KFDATA = 45056;
    static final int CHUNK_KFSEG = 45064;
    static final int CHUNK_OBJECT_NODE_TAG = 45058;
    static final int CHUNK_NODE_ID = 45104;
    static final int CHUNK_NODE_HDR = 45072;
    static final int CHUNK_PIVOT = 45075;
    static final int CHUNK_POS_TRACK_TAG = 45088;
    static final int CHUNK_ROT_TRACK_TAG = 45089;
    static final int CHUNK_SCL_TRACK_TAG = 45090;
    static final int CHUNK_MORPH_TRACK_TAG = 45094;
    static final int CHUNK_HIDE_TRACK_TAG = 45097;
    static final int CHUNK_TARGET_NODE_TAG = 45060;
    static final int CHUNK_CAMERA_NODE_TAG = 45059;
    static final int CHUNK_FOV_TRACK_TAG = 45091;
    static final int CHUNK_ROLL_TRACK_TAG = 45092;

    void addMesh(Mesh3ds mesh3ds) {
        this.mMesh.addElement(mesh3ds);
    }

    void addCamera(Camera3ds camera3ds) {
        this.mCamera.addElement(camera3ds);
    }

    void addMaterial(Material3ds material3ds) {
        this.mMaterial.addElement(material3ds);
    }

    public int meshes() {
        return this.mMesh.size();
    }

    public Mesh3ds mesh(int n) {
        return (Mesh3ds)this.mMesh.elementAt(n);
    }

    public int cameras() {
        return this.mCamera.size();
    }

    public Camera3ds camera(int n) {
        return (Camera3ds)this.mCamera.elementAt(n);
    }

    public int materials() {
        return this.mMaterial.size();
    }

    public Material3ds material(int n) {
        return (Material3ds)this.mMaterial.elementAt(n);
    }

    public int startFrame() {
        return this.mStartFrame;
    }

    public int endFrame() {
        return this.mEndFrame;
    }

    public Scene3ds(byte[] byArray, TextDecode3ds textDecode3ds, int n) throws Exception3ds {
        if (textDecode3ds != null) {
            this.mDecode = new Decode3ds(textDecode3ds, n);
        }
        this.mFileData = byArray;
        this.mFileLength = byArray.length;
        this.mFilePos = 0;
        try {
            try {
                this.read3DS();
            }
            catch (Exception3ds exception3ds) {
                throw new Exception3ds("3DS-parser: " + exception3ds.getMessage());
            }
            Object var6_4 = null;
            this.mFileData = null;
            this.mDecode = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.mFileData = null;
            this.mDecode = null;
            throw throwable;
        }
    }

    public Scene3ds(byte[] byArray) throws Exception3ds {
        this(byArray, null, 0);
    }

    public Scene3ds(File file, TextDecode3ds textDecode3ds, int n) throws Exception3ds {
        if (textDecode3ds != null) {
            this.mDecode = new Decode3ds(textDecode3ds, n);
        }
        try {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
                this.mFileData = new byte[(int)randomAccessFile.length()];
                randomAccessFile.readFully(this.mFileData);
                randomAccessFile.close();
                this.mFileLength = this.mFileData.length;
                this.mFilePos = 0;
                this.read3DS();
            }
            catch (IOException iOException) {
                throw new Exception3ds("I/O problems: " + iOException.getMessage());
            }
            catch (Exception3ds exception3ds) {
                throw new Exception3ds("3DS-parser: " + exception3ds.getMessage());
            }
            Object var7_6 = null;
            this.mFileData = null;
            this.mDecode = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.mFileData = null;
            this.mDecode = null;
            throw throwable;
        }
    }

    public Scene3ds(File file) throws Exception3ds {
        this(file, null, 0);
    }

    public Scene3ds(InputStream inputStream, TextDecode3ds textDecode3ds, int n) throws Exception3ds {
        if (textDecode3ds != null) {
            this.mDecode = new Decode3ds(textDecode3ds, n);
        }
        try {
            try {
                int n2;
                int n3 = 4096;
                int n4 = 0;
                byte[] byArray = new byte[n3];
                while ((n2 = inputStream.read()) != -1) {
                    byArray[n4++] = (byte)n2;
                    if (n4 < n3) continue;
                    byte[] byArray2 = new byte[n3 * 2];
                    System.arraycopy(byArray, 0, byArray2, 0, n3);
                    n3 *= 2;
                    byArray = byArray2;
                }
                this.mFileData = byArray;
                this.mFileLength = n4;
                this.mFilePos = 0;
                this.read3DS();
            }
            catch (IOException iOException) {
                throw new Exception3ds("I/O problems: " + iOException.getMessage());
            }
            catch (Exception3ds exception3ds) {
                throw new Exception3ds("3DS-parser: " + exception3ds.getMessage());
            }
            Object var10_11 = null;
            this.mFileData = null;
            this.mDecode = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.mFileData = null;
            this.mDecode = null;
            throw throwable;
        }
    }

    public Scene3ds(InputStream inputStream) throws Exception3ds {
        this(inputStream, null, 0);
    }

    private int filePos() {
        return this.mFilePos;
    }

    private byte readByte() throws Exception3ds {
        if (this.mFilePos >= this.mFileLength) {
            throw new Exception3ds("Read out of bounds! File is probably corrupt.");
        }
        return this.mFileData[this.mFilePos++];
    }

    private int readUnsignedShort() throws Exception3ds {
        if (this.mFilePos + 2 > this.mFileLength) {
            throw new Exception3ds("Read out of bounds! File is probably corrupt.");
        }
        int n = this.mFileData[this.mFilePos] & 0xFF | (this.mFileData[this.mFilePos + 1] & 0xFF) << 8;
        this.mFilePos += 2;
        return n;
    }

    private int readInt() throws Exception3ds {
        if (this.mFilePos + 4 > this.mFileLength) {
            throw new Exception3ds("Read out of bounds! File is probably corrupt.");
        }
        int n = this.mFileData[this.mFilePos] & 0xFF | (this.mFileData[this.mFilePos + 1] & 0xFF) << 8 | (this.mFileData[this.mFilePos + 2] & 0xFF) << 16 | this.mFileData[this.mFilePos + 3] << 24;
        this.mFilePos += 4;
        return n;
    }

    private float readFloat() throws Exception3ds {
        if (this.mFilePos + 4 > this.mFileLength) {
            throw new Exception3ds("Read out of bounds! File is probably corrupt.");
        }
        int n = this.mFileData[this.mFilePos] & 0xFF | (this.mFileData[this.mFilePos + 1] & 0xFF) << 8 | (this.mFileData[this.mFilePos + 2] & 0xFF) << 16 | this.mFileData[this.mFilePos + 3] << 24;
        this.mFilePos += 4;
        return Float.intBitsToFloat(n);
    }

    private int skipBytes(int n) throws Exception3ds {
        if (n < 0) {
            throw new Exception3ds("Negative chunk size! File is probably corrupt.");
        }
        if (this.mFilePos + n > this.mFileData.length) {
            throw new Exception3ds("Read out of bounds! File is probably corrupt.");
        }
        if (this.mDecode != null) {
            this.mDecode.printBytes(this.mFileData, this.mFilePos, n);
        }
        this.mFilePos += n;
        return n;
    }

    private void skipChunk(int n) throws Exception3ds {
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        this.skipBytes(n);
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private Head read_HEAD() throws Exception3ds {
        int n = this.readUnsignedShort();
        int n2 = this.readInt();
        if (this.mDecode != null) {
            this.mDecode.printHead(n, n2);
        }
        return new Head(n, n2);
    }

    private String read_NAME() throws Exception3ds {
        byte[] byArray = new byte[32];
        boolean bl = false;
        int n = 0;
        while (n < 32) {
            byArray[n] = this.readByte();
            if (byArray[n] == 0) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new Exception3ds("Name not terminated! File is probably corrupt.");
        }
        String string = new String(byArray, 0, n);
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Name: \"" + string + "\"");
            this.mDecode.leave();
        }
        return string;
    }

    private void read3DS() throws Exception3ds {
        Head head = this.read_HEAD();
        if (head.id != 19789) {
            throw new Exception3ds("Bad signature! This is not a 3D Studio R4 .3ds file.");
        }
        this.read_M3DMAGIC(head.length - 6);
    }

    private void read_M3DMAGIC(int n) throws Exception3ds {
        int n2 = this.filePos() + n;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        while (this.filePos() < n2) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 15677: {
                    this.read_MDATA(head.length - 6);
                    break;
                }
                case 45056: {
                    this.read_KFDATA(head.length - 6);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_MDATA(int n) throws Exception3ds {
        int n2 = this.filePos() + n;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        while (this.filePos() < n2) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 16384: {
                    this.read_NAMED_OBJECT(head.length - 6);
                    break;
                }
                case 45055: {
                    this.read_MAT_ENTRY(head.length - 6);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_MAT_ENTRY(int n) throws Exception3ds {
        int n2 = this.filePos() + n;
        Material3ds material3ds = new Material3ds();
        this.addMaterial(material3ds);
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        while (this.filePos() < n2) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 40960: {
                    material3ds.mName = this.read_NAME();
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_NAMED_OBJECT(int n) throws Exception3ds {
        int n2 = this.filePos() + n;
        String string = this.read_NAME();
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        while (this.filePos() < n2) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 16640: {
                    this.read_N_TRI_OBJECT(string, head.length - 6);
                    break;
                }
                case 18176: {
                    this.read_N_CAMERA(string, head.length - 6);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_N_CAMERA(String string, int n) throws Exception3ds {
        int n2 = this.filePos() + n;
        Camera3ds camera3ds = new Camera3ds();
        camera3ds.mName = string;
        this.addCamera(camera3ds);
        camera3ds.mPosition.X = this.readFloat();
        camera3ds.mPosition.Z = this.readFloat();
        camera3ds.mPosition.Y = this.readFloat();
        camera3ds.mTarget.X = this.readFloat();
        camera3ds.mTarget.Z = this.readFloat();
        camera3ds.mTarget.Y = this.readFloat();
        camera3ds.mRoll = this.readFloat();
        camera3ds.mLens = this.readFloat();
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Position: " + camera3ds.mPosition);
            this.mDecode.println("Target:   " + camera3ds.mTarget);
            this.mDecode.println("Roll: " + Utils3ds.floatToString(camera3ds.mRoll, 12));
            this.mDecode.println("Lens: " + Utils3ds.floatToString(camera3ds.mLens, 12));
        }
        while (this.filePos() < n2) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 18208: {
                    this.read_CAM_RANGES(camera3ds);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_CAM_RANGES(Camera3ds camera3ds) throws Exception3ds {
        camera3ds.mNearPlane = this.readFloat();
        camera3ds.mFarPlane = this.readFloat();
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Near plane:" + Utils3ds.floatToString(camera3ds.mNearPlane, 14));
            this.mDecode.println("Far plane: " + Utils3ds.floatToString(camera3ds.mFarPlane, 14));
            this.mDecode.leave();
        }
    }

    private void read_N_TRI_OBJECT(String string, int n) throws Exception3ds {
        int n2 = this.filePos() + n;
        Mesh3ds mesh3ds = new Mesh3ds();
        mesh3ds.mName = string;
        this.addMesh(mesh3ds);
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        while (this.filePos() < n2) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 16656: {
                    mesh3ds.mVertex = this.read_POINT_ARRAY();
                    break;
                }
                case 16704: {
                    mesh3ds.mTexCoord = this.read_TEX_VERTS();
                    break;
                }
                case 16752: {
                    this.read_MESH_TEXTURE_INFO(mesh3ds);
                    break;
                }
                case 16736: {
                    this.readMatrix(mesh3ds.mLocalSystem);
                    break;
                }
                case 16672: {
                    this.read_FACE_ARRAY(mesh3ds, head.length - 6);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private Vertex3ds[] read_POINT_ARRAY() throws Exception3ds {
        int n = this.readUnsignedShort();
        Vertex3ds[] vertex3dsArray = new Vertex3ds[n];
        int n2 = 0;
        while (n2 < n) {
            float f = this.readFloat();
            float f2 = this.readFloat();
            float f3 = this.readFloat();
            vertex3dsArray[n2] = new Vertex3ds(f, f3, f2);
            ++n2;
        }
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Vertices: " + n);
            int n3 = 0;
            while (n3 < n) {
                this.mDecode.println(" " + Utils3ds.intToString(n3, 4) + ":  " + vertex3dsArray[n3]);
                ++n3;
            }
            this.mDecode.leave();
        }
        return vertex3dsArray;
    }

    private TexCoord3ds[] read_TEX_VERTS() throws Exception3ds {
        int n = this.readUnsignedShort();
        TexCoord3ds[] texCoord3dsArray = new TexCoord3ds[n];
        int n2 = 0;
        while (n2 < n) {
            float f = this.readFloat();
            float f2 = this.readFloat();
            if (f < -100.0f || f > 100.0f) {
                f = 0.0f;
            }
            if (f2 < -100.0f || f2 > 100.0f) {
                f2 = 0.0f;
            }
            texCoord3dsArray[n2] = new TexCoord3ds(f, f2);
            ++n2;
        }
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Coords: " + n);
            int n3 = 0;
            while (n3 < n) {
                this.mDecode.println(" " + Utils3ds.intToString(n3, 4) + ":  " + texCoord3dsArray[n3]);
                ++n3;
            }
            this.mDecode.leave();
        }
        return texCoord3dsArray;
    }

    private void read_MESH_TEXTURE_INFO(Mesh3ds mesh3ds) throws Exception3ds {
        mesh3ds.mTexMapType = this.readUnsignedShort();
        mesh3ds.mTexUTile = this.readFloat();
        mesh3ds.mTexVTile = this.readFloat();
        if (this.mDecode != null) {
            this.mDecode.enter();
            String string = "";
            switch (mesh3ds.mTexMapType) {
                case 0: {
                    string = "PLANAR";
                    break;
                }
                case 1: {
                    string = "CYLINDRICAL";
                    break;
                }
                case 2: {
                    string = "SPHERICAL";
                    break;
                }
                default: {
                    string = "" + mesh3ds.mTexMapType;
                }
            }
            this.mDecode.println("Texture mapping type: " + string);
            this.mDecode.println("Texture U tiling: " + Utils3ds.floatToString(mesh3ds.mTexUTile, 9));
            this.mDecode.println("Texture V tiling: " + Utils3ds.floatToString(mesh3ds.mTexVTile, 9));
        }
        this.skipBytes(76);
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void readMatrix(float[][] fArray) throws Exception3ds {
        fArray[0][0] = this.readFloat();
        fArray[0][2] = this.readFloat();
        fArray[0][1] = this.readFloat();
        fArray[2][0] = this.readFloat();
        fArray[2][2] = this.readFloat();
        fArray[2][1] = this.readFloat();
        fArray[1][0] = this.readFloat();
        fArray[1][2] = this.readFloat();
        fArray[1][1] = this.readFloat();
        fArray[0][3] = this.readFloat();
        fArray[2][3] = this.readFloat();
        fArray[1][3] = this.readFloat();
        if (this.mDecode != null) {
            this.mDecode.enter();
            int n = 0;
            while (n < 3) {
                this.mDecode.println("" + Utils3ds.floatToString(fArray[n][0], 13) + " " + Utils3ds.floatToString(fArray[n][1], 13) + " " + Utils3ds.floatToString(fArray[n][2], 13) + " " + Utils3ds.floatToString(fArray[n][3], 13));
                ++n;
            }
            this.mDecode.leave();
        }
    }

    private void read_FACE_ARRAY(Mesh3ds mesh3ds, int n) throws Exception3ds {
        int n2;
        int n3 = this.filePos() + n;
        int n4 = this.readUnsignedShort();
        mesh3ds.mFace = new Face3ds[n4];
        int n5 = 0;
        while (n5 < n4) {
            n2 = this.readUnsignedShort();
            int n6 = this.readUnsignedShort();
            int n7 = this.readUnsignedShort();
            int n8 = this.readUnsignedShort();
            mesh3ds.mFace[n5] = new Face3ds(n2, n6, n7, n8);
            ++n5;
        }
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Faces: " + n4);
            n2 = 0;
            while (n2 < n4) {
                this.mDecode.println(" " + Utils3ds.intToString(n2, 4) + ":  " + mesh3ds.mFace[n2]);
                ++n2;
            }
        }
        while (this.filePos() < n3) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 16688: {
                    this.read_MSH_MAT_GROUP(mesh3ds);
                    break;
                }
                case 16720: {
                    this.read_SMOOTH_GROUP(mesh3ds, head.length - 6);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_MSH_MAT_GROUP(Mesh3ds mesh3ds) throws Exception3ds {
        String string = this.read_NAME();
        FaceMat3ds faceMat3ds = new FaceMat3ds();
        mesh3ds.addFaceMat(faceMat3ds);
        int n = 0;
        while (n < this.materials()) {
            if (this.material(n).name().equals(string)) {
                faceMat3ds.mMatIndex = n;
                break;
            }
            ++n;
        }
        int n2 = this.readUnsignedShort();
        faceMat3ds.mFaceIndex = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            faceMat3ds.mFaceIndex[n3] = this.readUnsignedShort();
            ++n3;
        }
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Faces: " + n2);
            int n4 = 0;
            while (n4 < n2) {
                this.mDecode.println("  face: " + faceMat3ds.mFaceIndex[n4]);
                ++n4;
            }
            this.mDecode.leave();
        }
    }

    private void read_SMOOTH_GROUP(Mesh3ds mesh3ds, int n) throws Exception3ds {
        int n2 = n / 4;
        mesh3ds.mSmoothGroup = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            mesh3ds.mSmoothGroup[n3] = this.readInt();
            ++n3;
        }
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Entrys: " + n2);
            int n4 = 0;
            while (n4 < n2) {
                this.mDecode.println(Utils3ds.intToString(n4, 4) + ": " + Utils3ds.intToBinString(mesh3ds.mSmoothGroup[n4], 32));
                ++n4;
            }
            this.mDecode.leave();
        }
        if (n2 != mesh3ds.faces()) {
            throw new Exception3ds("SMOOTH_GROUP entrys != faces. File is probably corrupt!");
        }
    }

    private void read_KFDATA(int n) throws Exception3ds {
        int n2 = this.filePos() + n;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        block6: while (this.filePos() < n2) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 45064: {
                    this.mStartFrame = this.readInt();
                    this.mEndFrame = this.readInt();
                    if (this.mDecode == null) continue block6;
                    this.mDecode.enter();
                    this.mDecode.println("Start frame: " + this.mStartFrame);
                    this.mDecode.println("End frame:   " + this.mEndFrame);
                    this.mDecode.leave();
                    break;
                }
                case 45058: {
                    this.read_OBJECT_NODE_TAG(head.length - 6);
                    break;
                }
                case 45060: {
                    this.read_TARGET_NODE_TAG(head.length - 6);
                    break;
                }
                case 45059: {
                    this.read_CAMERA_NODE_TAG(head.length - 6);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_OBJECT_NODE_TAG(int n) throws Exception3ds {
        int n2 = this.filePos() + n;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int n3 = 0;
        String string = "";
        int n4 = 0;
        Mesh3ds mesh3ds = null;
        block10: while (this.filePos() < n2) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 45104: {
                    n3 = this.read_NODE_ID();
                    break;
                }
                case 45072: {
                    string = this.read_NAME();
                    int n5 = 0;
                    while (n5 < this.meshes()) {
                        if (this.mesh(n5).name().equals(string)) {
                            n4 = n5;
                            break;
                        }
                        ++n5;
                    }
                    mesh3ds = this.mesh(n4);
                    mesh3ds.mNodeId = n3;
                    mesh3ds.mNodeFlags = this.readInt();
                    mesh3ds.mParentNodeId = this.readUnsignedShort();
                    if (this.mDecode == null) continue block10;
                    this.mDecode.enter();
                    this.mDecode.println("Node flags: 0x" + Utils3ds.intToHexString(mesh3ds.mNodeFlags, 8));
                    this.mDecode.println("Parent node id: " + mesh3ds.mParentNodeId);
                    this.mDecode.leave();
                    break;
                }
                case 45075: {
                    mesh3ds.mPivot.X = this.readFloat();
                    mesh3ds.mPivot.Z = this.readFloat();
                    mesh3ds.mPivot.Y = this.readFloat();
                    if (this.mDecode == null) continue block10;
                    this.mDecode.enter();
                    this.mDecode.println(mesh3ds.mPivot.toString());
                    this.mDecode.leave();
                    break;
                }
                case 45088: {
                    this.read_POS_TRACK_TAG(mesh3ds.mPositionTrack);
                    break;
                }
                case 45089: {
                    this.read_ROT_TRACK_TAG(mesh3ds.mRotationTrack);
                    break;
                }
                case 45090: {
                    this.read_POS_TRACK_TAG(mesh3ds.mScaleTrack);
                    break;
                }
                case 45094: {
                    this.read_MORPH_TRACK_TAG(mesh3ds.mMorphTrack);
                    break;
                }
                case 45097: {
                    this.read_HIDE_TRACK_TAG(mesh3ds.mHideTrack);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_TARGET_NODE_TAG(int n) throws Exception3ds {
        int n2 = this.filePos() + n;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int n3 = 0;
        String string = "";
        int n4 = 0;
        Camera3ds camera3ds = null;
        block5: while (this.filePos() < n2) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 45104: {
                    n3 = this.read_NODE_ID();
                    break;
                }
                case 45072: {
                    string = this.read_NAME();
                    int n5 = 0;
                    while (n5 < this.cameras()) {
                        if (this.camera(n5).name().equals(string)) {
                            n4 = n5;
                            break;
                        }
                        ++n5;
                    }
                    camera3ds = this.camera(n4);
                    camera3ds.mTargetNodeId = n3;
                    camera3ds.mTargetNodeFlags = this.readInt();
                    camera3ds.mTargetParentNodeId = this.readUnsignedShort();
                    if (this.mDecode == null) continue block5;
                    this.mDecode.enter();
                    this.mDecode.println("Target node flags: 0x" + Utils3ds.intToHexString(camera3ds.mTargetNodeFlags, 8));
                    this.mDecode.println("Target parent node id: " + camera3ds.mTargetParentNodeId);
                    this.mDecode.leave();
                    break;
                }
                case 45088: {
                    this.read_POS_TRACK_TAG(camera3ds.mTargetTrack);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_CAMERA_NODE_TAG(int n) throws Exception3ds {
        int n2 = this.filePos() + n;
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int n3 = 0;
        String string = "";
        int n4 = 0;
        Camera3ds camera3ds = null;
        block7: while (this.filePos() < n2) {
            Head head = this.read_HEAD();
            switch (head.id) {
                case 45104: {
                    n3 = this.read_NODE_ID();
                    break;
                }
                case 45072: {
                    string = this.read_NAME();
                    int n5 = 0;
                    while (n5 < this.cameras()) {
                        if (this.camera(n5).name().equals(string)) {
                            n4 = n5;
                            break;
                        }
                        ++n5;
                    }
                    camera3ds = this.camera(n4);
                    camera3ds.mPositionNodeId = n3;
                    camera3ds.mPositionNodeFlags = this.readInt();
                    camera3ds.mPositionParentNodeId = this.readUnsignedShort();
                    if (this.mDecode == null) continue block7;
                    this.mDecode.enter();
                    this.mDecode.println("Position node flags: 0x" + Utils3ds.intToHexString(camera3ds.mPositionNodeFlags, 8));
                    this.mDecode.println("Position parent node id: " + camera3ds.mPositionParentNodeId);
                    this.mDecode.leave();
                    break;
                }
                case 45088: {
                    this.read_POS_TRACK_TAG(camera3ds.mPositionTrack);
                    break;
                }
                case 45091: {
                    this.readPTrack(camera3ds.mFovTrack);
                    break;
                }
                case 45092: {
                    this.readPTrack(camera3ds.mRollTrack);
                    break;
                }
                default: {
                    this.skipChunk(head.length - 6);
                }
            }
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private int read_NODE_ID() throws Exception3ds {
        int n = this.readUnsignedShort();
        if (this.mDecode != null) {
            this.mDecode.enter();
            this.mDecode.println("Node id: " + n);
            this.mDecode.leave();
        }
        return n;
    }

    private int readTrackHead(Track3ds track3ds) throws Exception3ds {
        int n;
        track3ds.mFlags = n = this.readUnsignedShort();
        if (this.mDecode != null) {
            String string;
            switch (track3ds.loopType()) {
                case 0: {
                    string = "SINGLE";
                    break;
                }
                case 2: {
                    string = "REPEAT";
                    break;
                }
                case 3: {
                    string = "LOOP";
                    break;
                }
                default: {
                    string = "" + track3ds.loopType();
                }
            }
            this.mDecode.println("Loop type: " + string);
            this.mDecode.println("Flags: lock " + ((n & 8) == 8 ? "X " : "- ") + ((n & 0x10) == 16 ? "Y " : "- ") + ((n & 0x20) == 32 ? "Z " : "- ") + "  unlink " + ((n & 0x80) == 128 ? "X " : "- ") + ((n & 0x100) == 256 ? "Y " : "- ") + ((n & 0x200) == 512 ? "Z " : "- "));
        }
        this.skipBytes(8);
        int n2 = this.readInt();
        if (this.mDecode != null) {
            this.mDecode.println("Keys: " + n2);
        }
        return n2;
    }

    private void readSplineParams(SplineKey3ds splineKey3ds) throws Exception3ds {
        int n = this.readUnsignedShort();
        if (n != 0) {
            if ((n & 1) != 0) {
                splineKey3ds.Tension = this.readFloat();
                if (this.mDecode != null) {
                    this.mDecode.println("    Tension:    " + Utils3ds.floatToString(splineKey3ds.Tension, 7));
                }
            }
            if ((n & 2) != 0) {
                splineKey3ds.Bias = this.readFloat();
                if (this.mDecode != null) {
                    this.mDecode.println("    Bias:       " + Utils3ds.floatToString(splineKey3ds.Bias, 7));
                }
            }
            if ((n & 4) != 0) {
                splineKey3ds.Continuity = this.readFloat();
                if (this.mDecode != null) {
                    this.mDecode.println("    Continuity: " + Utils3ds.floatToString(splineKey3ds.Continuity, 7));
                }
            }
            if ((n & 8) != 0) {
                splineKey3ds.EaseTo = this.readFloat();
                if (this.mDecode != null) {
                    this.mDecode.println("    Ease to:    " + Utils3ds.floatToString(splineKey3ds.EaseTo, 7));
                }
            }
            if ((n & 0x10) != 0) {
                splineKey3ds.EaseFrom = this.readFloat();
                if (this.mDecode != null) {
                    this.mDecode.println("    Ease from:  " + Utils3ds.floatToString(splineKey3ds.EaseFrom, 7));
                }
            }
        }
    }

    private void readPTrack(PTrack3ds pTrack3ds) throws Exception3ds {
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int n = this.readTrackHead(pTrack3ds);
        pTrack3ds.mKey = new PKey3ds[n];
        int n2 = 0;
        while (n2 < n) {
            PKey3ds pKey3ds = new PKey3ds();
            pKey3ds.Frame = this.readInt();
            if (this.mDecode != null) {
                this.mDecode.println("  Frame: " + pKey3ds.Frame);
            }
            this.readSplineParams(pKey3ds);
            pKey3ds.P = this.readFloat();
            if (this.mDecode != null) {
                this.mDecode.println("  " + Utils3ds.floatToString(pKey3ds.P, 13));
            }
            pTrack3ds.mKey[n2] = pKey3ds;
            ++n2;
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_POS_TRACK_TAG(XYZTrack3ds xYZTrack3ds) throws Exception3ds {
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int n = this.readTrackHead(xYZTrack3ds);
        xYZTrack3ds.mKey = new XYZKey3ds[n];
        int n2 = 0;
        while (n2 < n) {
            XYZKey3ds xYZKey3ds = new XYZKey3ds();
            xYZKey3ds.Frame = this.readInt();
            if (this.mDecode != null) {
                this.mDecode.println("  Frame: " + xYZKey3ds.Frame);
            }
            this.readSplineParams(xYZKey3ds);
            xYZKey3ds.X = this.readFloat();
            xYZKey3ds.Z = this.readFloat();
            xYZKey3ds.Y = this.readFloat();
            if (this.mDecode != null) {
                this.mDecode.println("    X Y Z:" + Utils3ds.floatToString(xYZKey3ds.X, 13) + Utils3ds.floatToString(xYZKey3ds.Y, 13) + Utils3ds.floatToString(xYZKey3ds.Z, 13));
            }
            xYZTrack3ds.mKey[n2] = xYZKey3ds;
            ++n2;
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_ROT_TRACK_TAG(RotationTrack3ds rotationTrack3ds) throws Exception3ds {
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int n = this.readTrackHead(rotationTrack3ds);
        rotationTrack3ds.mKey = new RotationKey3ds[n];
        int n2 = 0;
        while (n2 < n) {
            RotationKey3ds rotationKey3ds = new RotationKey3ds();
            rotationKey3ds.Frame = this.readInt();
            if (this.mDecode != null) {
                this.mDecode.println("  Frame: " + rotationKey3ds.Frame);
            }
            this.readSplineParams(rotationKey3ds);
            rotationKey3ds.A = this.readFloat();
            rotationKey3ds.X = this.readFloat();
            rotationKey3ds.Z = this.readFloat();
            rotationKey3ds.Y = this.readFloat();
            if (this.mDecode != null) {
                this.mDecode.println("    A X Y Z:" + Utils3ds.floatToString(rotationKey3ds.A, 12) + Utils3ds.floatToString(rotationKey3ds.X, 9) + Utils3ds.floatToString(rotationKey3ds.Y, 9) + Utils3ds.floatToString(rotationKey3ds.Z, 9));
            }
            rotationTrack3ds.mKey[n2] = rotationKey3ds;
            ++n2;
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_MORPH_TRACK_TAG(MorphTrack3ds morphTrack3ds) throws Exception3ds {
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        int n = this.readTrackHead(morphTrack3ds);
        morphTrack3ds.mKey = new MorphKey3ds[n];
        int n2 = 0;
        while (n2 < n) {
            MorphKey3ds morphKey3ds = new MorphKey3ds();
            morphKey3ds.Frame = this.readInt();
            if (this.mDecode != null) {
                this.mDecode.println("  Frame: " + morphKey3ds.Frame);
            }
            this.readSplineParams(morphKey3ds);
            String string = this.read_NAME();
            int n3 = 0;
            while (n3 < this.meshes()) {
                if (this.mesh(n3).name().equals(string)) {
                    morphKey3ds.Mesh = n3;
                    break;
                }
                ++n3;
            }
            morphTrack3ds.mKey[n2] = morphKey3ds;
            ++n2;
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private void read_HIDE_TRACK_TAG(HideTrack3ds hideTrack3ds) throws Exception3ds {
        if (this.mDecode != null) {
            this.mDecode.enter();
        }
        SplineKey3ds splineKey3ds = new SplineKey3ds();
        int n = this.readTrackHead(hideTrack3ds);
        hideTrack3ds.mKey = new HideKey3ds[n];
        int n2 = 0;
        while (n2 < n) {
            HideKey3ds hideKey3ds = new HideKey3ds();
            hideKey3ds.Frame = this.readInt();
            if (this.mDecode != null) {
                this.mDecode.println("  Frame: " + hideKey3ds.Frame);
            }
            this.readSplineParams(splineKey3ds);
            hideTrack3ds.mKey[n2] = hideKey3ds;
            ++n2;
        }
        if (this.mDecode != null) {
            this.mDecode.leave();
        }
    }

    private static class Head {
        public int id;
        public int length;

        public Head(int n, int n2) {
            this.id = n;
            this.length = n2;
        }
    }
}

