/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;

public class GaussianBlur
implements ExtendedPlugInFilter,
DialogListener {
    private static double sigma = 2.0;
    private static boolean sigmaScaled = false;
    private int flags = 16810079;
    private ImagePlus imp;
    private boolean hasScale = false;
    private int nPasses = 1;
    private int nChannels = 1;
    private int pass;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (imp != null && imp.getRoi() != null) {
            Rectangle roiRect = imp.getRoi().getBoundingRect();
            if (roiRect.y > 0 || roiRect.y + roiRect.height < imp.getDimensions()[1]) {
                this.flags |= 0x4000;
            }
        }
        return this.flags;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        String options = Macro.getOptions();
        boolean oldMacro = false;
        this.nChannels = imp.getProcessor().getNChannels();
        if (options != null && options.indexOf("radius=") >= 0) {
            oldMacro = true;
            Macro.setOptions(options.replaceAll("radius=", "sigma="));
        }
        GenericDialog gd = new GenericDialog(command);
        sigma = Math.abs(sigma);
        gd.addNumericField("Sigma (Radius)", sigma, 2);
        if (imp.getCalibration() != null && !imp.getCalibration().getUnits().equals("pixels")) {
            this.hasScale = true;
            gd.addCheckbox("Scaled Units (" + imp.getCalibration().getUnits() + ")", sigmaScaled);
        } else {
            sigmaScaled = false;
        }
        gd.addPreviewCheckbox(pfr);
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        if (oldMacro) {
            sigma /= 2.5;
        }
        IJ.register(this.getClass());
        return IJ.setupDialog(imp, this.flags);
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        sigma = gd.getNextNumber();
        if (sigma < 0.0 || gd.invalidNumber()) {
            return false;
        }
        if (this.hasScale) {
            sigmaScaled = gd.getNextBoolean();
        }
        return true;
    }

    public void setNPasses(int nPasses) {
        this.nPasses = 2 * this.nChannels * nPasses;
        this.pass = 0;
    }

    public void run(ImageProcessor ip) {
        double sigmaX = sigmaScaled ? sigma / this.imp.getCalibration().pixelWidth : sigma;
        double sigmaY = sigmaScaled ? sigma / this.imp.getCalibration().pixelHeight : sigma;
        double accuracy = ip instanceof ByteProcessor || ip instanceof ColorProcessor ? 0.002 : 2.0E-4;
        Rectangle roi = ip.getRoi();
        this.blurGaussian(ip, sigmaX, sigmaY, accuracy);
    }

    public boolean blur(ImageProcessor ip, double radius) {
        Rectangle roi = ip.getRoi();
        if (roi.height != ip.getHeight() && ip.getMask() == null) {
            ip.snapshot();
        }
        this.blurGaussian(ip, 0.4 * radius, 0.4 * radius, 0.01);
        return true;
    }

    public void blurGaussian(ImageProcessor ip, double sigmaX, double sigmaY, double accuracy) {
        if (this.nPasses <= 1) {
            this.nPasses = ip.getNChannels() * (sigmaX > 0.0 && sigmaY > 0.0 ? 2 : 1);
        }
        FloatProcessor fp = null;
        for (int i = 0; i < ip.getNChannels(); ++i) {
            fp = ip.toFloat(i, fp);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.blurFloat(fp, sigmaX, sigmaY, accuracy);
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            ip.setPixels(i, fp);
        }
        if (ip.getRoi().height != ip.getHeight() && sigmaX > 0.0 && sigmaY > 0.0) {
            GaussianBlur.resetOutOfRoi(ip, (int)Math.ceil(5.0 * sigmaY));
        }
    }

    public void blurFloat(FloatProcessor ip, double sigmaX, double sigmaY, double accuracy) {
        if (sigmaX > 0.0) {
            this.blur1Direction(ip, sigmaX, accuracy, true, (int)Math.ceil(5.0 * sigmaY));
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (sigmaY > 0.0) {
            this.blur1Direction(ip, sigmaY, accuracy, false, 0);
        }
    }

    public void blur1Direction(FloatProcessor ip, double sigma, double accuracy, boolean xDirection, int extraLines) {
        int lineTo;
        int UPSCALE_K_RADIUS = 2;
        double MIN_DOWNSCALED_SIGMA = 4.0;
        float[] pixels = (float[])ip.getPixels();
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        int length = xDirection ? width : height;
        int pointInc = xDirection ? 1 : width;
        int lineInc = xDirection ? width : 1;
        int lineFrom = (xDirection ? roi.y : roi.x) - extraLines;
        if (lineFrom < 0) {
            lineFrom = 0;
        }
        if ((lineTo = (xDirection ? roi.y + roi.height : roi.x + roi.width) + extraLines) > (xDirection ? height : width)) {
            lineTo = xDirection ? height : width;
        }
        int writeFrom = xDirection ? roi.x : roi.y;
        int writeTo = xDirection ? roi.x + roi.width : roi.y + roi.height;
        int inc = Math.max((lineTo - lineFrom) / (100 / (this.nPasses > 0 ? this.nPasses : 1) + 1), 20);
        ++this.pass;
        if (this.pass > this.nPasses) {
            this.pass = 1;
        }
        Thread thread = Thread.currentThread();
        if (sigma > 8.5) {
            int maxLength;
            double sigmaGauss;
            float[][] gaussKernel;
            int kRadius;
            int reduceBy = (int)Math.floor(sigma / 4.0);
            if (reduceBy > length) {
                reduceBy = length;
            }
            int readFrom = writeFrom - (kRadius = (gaussKernel = this.makeGaussianKernel(sigmaGauss = Math.sqrt(sigma * sigma / (double)(reduceBy * reduceBy) - 0.3333333333333333 - 0.25), accuracy, maxLength = (length + reduceBy - 1) / reduceBy + 6))[0].length * reduceBy) < 0 ? 0 : writeFrom - kRadius;
            int readTo = writeTo + kRadius > length ? length : writeTo + kRadius;
            int newLength = (readTo - readFrom + reduceBy - 1) / reduceBy + 6;
            int unscaled0 = readFrom - 3 * reduceBy;
            float[] downscaleKernel = this.makeDownscaleKernel(reduceBy);
            float[] upscaleKernel = this.makeUpscaleKernel(reduceBy);
            float[] cache1 = new float[newLength];
            float[] cache2 = new float[newLength];
            int pixel0 = lineFrom * lineInc;
            int line = lineFrom;
            while (line < lineTo) {
                if (line % inc == 0) {
                    this.showProgress((double)(line - lineFrom) / (double)(lineTo - lineFrom));
                    if (thread.isInterrupted()) {
                        return;
                    }
                }
                this.downscaleLine(pixels, cache1, downscaleKernel, reduceBy, pixel0, unscaled0, length, pointInc, newLength);
                this.convolveLine(cache1, cache2, gaussKernel, 0, newLength, 1, newLength - 1, 0, 1);
                this.upscaleLine(cache2, pixels, upscaleKernel, reduceBy, pixel0, unscaled0, writeFrom, writeTo, pointInc);
                ++line;
                pixel0 += lineInc;
            }
        } else {
            float[][] gaussKernel = this.makeGaussianKernel(sigma, accuracy, length);
            int kRadius = gaussKernel[0].length;
            float[] cache = new float[length];
            int readFrom = writeFrom - kRadius < 0 ? 0 : writeFrom - kRadius;
            int readTo = writeTo + kRadius > length ? length : writeTo + kRadius;
            int pixel0 = lineFrom * lineInc;
            int line = lineFrom;
            while (line < lineTo) {
                if (line % inc == 0) {
                    this.showProgress((double)(line - lineFrom) / (double)(lineTo - lineFrom));
                    if (thread.isInterrupted()) {
                        return;
                    }
                }
                int p = pixel0 + readFrom * pointInc;
                int i = readFrom;
                while (i < readTo) {
                    cache[i] = pixels[p];
                    ++i;
                    p += pointInc;
                }
                this.convolveLine(cache, pixels, gaussKernel, readFrom, readTo, writeFrom, writeTo, pixel0, pointInc);
                ++line;
                pixel0 += lineInc;
            }
        }
        this.showProgress(1.0);
    }

    void downscaleLine(float[] pixels, float[] cache, float[] kernel, int reduceBy, int pixel0, int unscaled0, int length, int pointInc, int newLength) {
        float first = pixels[pixel0];
        float last = pixels[pixel0 + pointInc * (length - 1)];
        int xin = unscaled0 - reduceBy / 2;
        int p = pixel0 + pointInc * xin;
        for (int xout = 0; xout < newLength; ++xout) {
            float v = 0.0f;
            int x = 0;
            while (x < reduceBy) {
                v += kernel[x] * (xin - reduceBy < 0 ? first : (xin - reduceBy >= length ? last : pixels[p - pointInc * reduceBy]));
                v += kernel[x + reduceBy] * (xin < 0 ? first : (xin >= length ? last : pixels[p]));
                v += kernel[x + 2 * reduceBy] * (xin + reduceBy < 0 ? first : (xin + reduceBy >= length ? last : pixels[p + pointInc * reduceBy]));
                ++x;
                ++xin;
                p += pointInc;
            }
            cache[xout] = v;
        }
    }

    float[] makeDownscaleKernel(int unitLength) {
        float v;
        double x;
        int i;
        int mid = unitLength * 3 / 2;
        float[] kernel = new float[3 * unitLength];
        for (i = 0; i <= unitLength / 2; ++i) {
            x = (double)i / (double)unitLength;
            kernel[mid - i] = v = (float)((0.75 - x * x) / (double)unitLength);
            kernel[mid + i] = v;
        }
        for (i = unitLength / 2 + 1; i < (unitLength * 3 + 1) / 2; ++i) {
            x = (double)i / (double)unitLength;
            kernel[mid - i] = v = (float)((0.125 + 0.5 * (x - 1.0) * (x - 2.0)) / (double)unitLength);
            kernel[mid + i] = v;
        }
        return kernel;
    }

    void upscaleLine(float[] cache, float[] pixels, float[] kernel, int reduceBy, int pixel0, int unscaled0, int writeFrom, int writeTo, int pointInc) {
        int p = pixel0 + pointInc * writeFrom;
        int xout = writeFrom;
        while (xout < writeTo) {
            int xin = (xout - unscaled0 + reduceBy - 1) / reduceBy;
            int x = reduceBy - 1 - (xout - unscaled0 + reduceBy - 1) % reduceBy;
            pixels[p] = cache[xin - 2] * kernel[x] + cache[xin - 1] * kernel[x + reduceBy] + cache[xin] * kernel[x + 2 * reduceBy] + cache[xin + 1] * kernel[x + 3 * reduceBy];
            ++xout;
            p += pointInc;
        }
    }

    float[] makeUpscaleKernel(int unitLength) {
        float v;
        double x;
        int i;
        float[] kernel = new float[4 * unitLength];
        int mid = 2 * unitLength;
        kernel[0] = 0.0f;
        for (i = 0; i < unitLength; ++i) {
            x = (double)i / (double)unitLength;
            kernel[mid + i] = v = (float)(0.6666666666666666 - x * x * (1.0 - 0.5 * x));
            kernel[mid - i] = v;
        }
        for (i = unitLength; i < 2 * unitLength; ++i) {
            x = (double)i / (double)unitLength;
            kernel[mid + i] = v = (float)((2.0 - x) * (2.0 - x) * (2.0 - x) / 6.0);
            kernel[mid - i] = v;
        }
        return kernel;
    }

    public void convolveLine(float[] input, float[] pixels, float[][] kernel, int readFrom, int readTo, int writeFrom, int writeTo, int point0, int pointInc) {
        int iEndInside;
        int length = input.length;
        float first = input[0];
        float last = input[length - 1];
        float[] kern = kernel[0];
        float kern0 = kern[0];
        float[] kernSum = kernel[1];
        int kRadius = kern.length;
        int firstPart = kRadius < length ? kRadius : length;
        int p = point0 + writeFrom * pointInc;
        int i = writeFrom;
        while (i < firstPart) {
            float result = input[i] * kern0;
            result += kernSum[i] * first;
            if (i + kRadius > length) {
                result += kernSum[length - i - 1] * last;
            }
            for (int k = 1; k < kRadius; ++k) {
                float v = 0.0f;
                if (i - k >= 0) {
                    v += input[i - k];
                }
                if (i + k < length) {
                    v += input[i + k];
                }
                result += kern[k] * v;
            }
            pixels[p] = result;
            ++i;
            p += pointInc;
        }
        int n = iEndInside = length - kRadius < writeTo ? length - kRadius : writeTo;
        while (i < iEndInside) {
            float result = input[i] * kern0;
            for (int k = 1; k < kRadius; ++k) {
                result += kern[k] * (input[i - k] + input[i + k]);
            }
            pixels[p] = result;
            ++i;
            p += pointInc;
        }
        while (i < writeTo) {
            float result = input[i] * kern0;
            if (i < kRadius) {
                result += kernSum[i] * first;
            }
            if (i + kRadius >= length) {
                result += kernSum[length - i - 1] * last;
            }
            for (int k = 1; k < kRadius; ++k) {
                float v = 0.0f;
                if (i - k >= 0) {
                    v += input[i - k];
                }
                if (i + k < length) {
                    v += input[i + k];
                }
                result += kern[k] * v;
            }
            pixels[p] = result;
            ++i;
            p += pointInc;
        }
    }

    public float[][] makeGaussianKernel(double sigma, double accuracy, int maxRadius) {
        double sum;
        int kRadius = (int)Math.ceil(sigma * Math.sqrt(-2.0 * Math.log(accuracy))) + 1;
        if (maxRadius < 50) {
            maxRadius = 50;
        }
        if (kRadius > maxRadius) {
            kRadius = maxRadius;
        }
        float[][] kernel = new float[2][kRadius];
        for (int i = 0; i < kRadius; ++i) {
            kernel[0][i] = (float)Math.exp(-0.5 * (double)i * (double)i / sigma / sigma);
        }
        if (kRadius < maxRadius && kRadius > 3) {
            double a;
            double sqrtSlope = Double.MAX_VALUE;
            int r = kRadius;
            while (r > kRadius / 2 && (a = Math.sqrt(kernel[0][--r]) / (double)(kRadius - r)) < sqrtSlope) {
                sqrtSlope = a;
            }
            for (int r1 = r + 2; r1 < kRadius; ++r1) {
                kernel[0][r1] = (float)((double)((kRadius - r1) * (kRadius - r1)) * sqrtSlope * sqrtSlope);
            }
        }
        if (kRadius < maxRadius) {
            sum = kernel[0][0];
            for (int i = 1; i < kRadius; ++i) {
                sum += (double)(2.0f * kernel[0][i]);
            }
        } else {
            sum = sigma * Math.sqrt(Math.PI * 2);
        }
        double rsum = 0.5 + 0.5 * (double)kernel[0][0] / sum;
        for (int i = 0; i < kRadius; ++i) {
            double v = (double)kernel[0][i] / sum;
            kernel[0][i] = (float)v;
            kernel[1][i] = (float)(rsum -= v);
        }
        return kernel;
    }

    public static void resetOutOfRoi(ImageProcessor ip, int radius) {
        Rectangle roi = ip.getRoi();
        int width = ip.getWidth();
        int height = ip.getHeight();
        Object pixels = ip.getPixels();
        Object snapshot = ip.getSnapshotPixels();
        int y0 = roi.y - radius;
        if (y0 < 0) {
            y0 = 0;
        }
        int y = y0;
        int p = width * y + roi.x;
        while (y < roi.y) {
            System.arraycopy(snapshot, p, pixels, p, roi.width);
            ++y;
            p += width;
        }
        int yEnd = roi.y + roi.height + radius;
        if (yEnd > height) {
            yEnd = height;
        }
        int y2 = roi.y + roi.height;
        int p2 = width * y2 + roi.x;
        while (y2 < yEnd) {
            System.arraycopy(snapshot, p2, pixels, p2, roi.width);
            ++y2;
            p2 += width;
        }
    }

    void showProgress(double percent) {
        percent = (double)(this.pass - 1) / (double)this.nPasses + percent / (double)this.nPasses;
        IJ.showProgress(percent);
    }
}

