/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.imageio.ImageIO;

public class PNG_Writer
implements PlugIn {
    ImagePlus imp;

    public void run(String path) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (path.equals("")) {
            SaveDialog sd = new SaveDialog("Save as PNG...", this.imp.getTitle(), ".png");
            String name = sd.getFileName();
            if (name == null) {
                return;
            }
            String dir = sd.getDirectory();
            path = dir + name;
        }
        try {
            this.writeImage(this.imp, path, Prefs.getTransparentIndex());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.showMessage("PNG Writer", "An error occured writing the file.\n \n" + msg);
        }
        IJ.showStatus("");
    }

    public void writeImage(ImagePlus imp, String path, int transparentIndex) throws Exception {
        if (transparentIndex >= 0 && transparentIndex <= 255 && imp.getBitDepth() == 8) {
            this.writeImageWithTransparency(imp, path, transparentIndex);
        } else if (imp.getBitDepth() == 16 && !imp.isComposite() && imp.getProcessor().isDefaultLut()) {
            this.write16gs(imp, path);
        } else {
            ImageIO.write((RenderedImage)imp.getBufferedImage(), "png", new File(path));
        }
    }

    void writeImageWithTransparency(ImagePlus imp, String path, int transparentIndex) throws Exception {
        int width = imp.getWidth();
        int height = imp.getHeight();
        ImageProcessor ip = imp.getProcessor();
        IndexColorModel cm = (IndexColorModel)ip.getColorModel();
        int size = cm.getMapSize();
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        cm.getReds(reds);
        cm.getGreens(greens);
        cm.getBlues(blues);
        cm = new IndexColorModel(8, 256, reds, greens, blues, transparentIndex);
        WritableRaster wr = cm.createCompatibleWritableRaster(width, height);
        DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
        byte[] biPixels = db.getData();
        System.arraycopy(ip.getPixels(), 0, biPixels, 0, biPixels.length);
        BufferedImage bi = new BufferedImage(cm, wr, false, null);
        ImageIO.write((RenderedImage)bi, "png", new File(path));
    }

    void write16gs(ImagePlus imp, String path) throws Exception {
        int width = imp.getWidth();
        int height = imp.getHeight();
        BufferedImage bi = new BufferedImage(width, height, 11);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.drawImage(imp.getImage(), 0, 0, null);
        File f = new File(path);
        ImageIO.write((RenderedImage)bi, "png", f);
    }
}

