package tts.filetospeech;

import java.io.*;
import java.util.*;
import android.app.Activity;
import android.os.*;
import android.util.Log;
import android.view.View;
import android.widget.*;
//import android.media.AudioManager;
import android.speech.tts.TextToSpeech;
import android.speech.tts.TextToSpeech.*; 

public class MainActivity extends Activity
                                 implements  OnInitListener
{
	ImageButton ttsButton;
	Button pauseButton;
	Button resumeButton;
	TextView msg;
	TextToSpeech tts;
	InputStream is = null;
	BufferedReader reader;
	boolean firstTime = true;  //First time reading text to synthesize
	Speech speech = null;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
	 
	    ttsButton = (ImageButton) findViewById(R.id.ttsButton);
        msg = (TextView) findViewById(R.id.msg);
        pauseButton = (Button) findViewById(R.id.pauseButton);
        resumeButton = (Button) findViewById(R.id.resumeButton);
        tts = new TextToSpeech(this, this);
	}	
	
    public void onStart(View view) {
      if ( firstTime ) {
    	is = getResources().openRawResource(R.raw.myfile);
	    speech = new Speech ( tts, is );
	    Thread speechThread = new Thread ( speech );
	    speechThread.start();   // start thread to speak
	    firstTime = false;
      }	
    	System.out.println ("onStart");
	}
	  
    public void onPause ( View view ) {
      if ( speech != null )
    	  speech.speechPause();
      System.out.println("onPause");
    }
    
    public void onResume ( View view ){
    	if ( speech != null )
      	  speech.speechResume();
    	System.out.println("onResume");
      }
    
	@Override
	public void onInit(int state) {
	    if (state == TextToSpeech.SUCCESS) {
            msg.setText("TTS initialized successfully!\n " +
            		"Click TTS to start speaking.");
            int result = tts.setLanguage(Locale.US);
 
            if (result == TextToSpeech.LANG_MISSING_DATA
                    || result == TextToSpeech.LANG_NOT_SUPPORTED) {
                msg.setText("TTS: Language not supported!");
            } else {
                ttsButton.setEnabled(true);
            } 
        } else {
            msg.setText("TTS: Initilization Failed!");
        }	
	}

	@Override
    public void onDestroy() {
        // Don't forget to shutdown tts!
        if (tts != null) {
            tts.stop();
            tts.shutdown();
        }
        super.onDestroy();
    }  
}