package tts.audiodemo1;

import java.io.IOException;

import android.os.*;
import android.widget.Toast;
import android.app.Activity;
import android.media.MediaPlayer;
import android.media.AudioManager;
import android.media.MediaPlayer.OnCompletionListener;

public class MainActivity extends Activity
{
	MediaPlayer mp = null;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		mp = new MediaPlayer();
		String url = "http://www.forejune.com/android/files/sound1.wav";
		mp.setAudioStreamType(AudioManager.STREAM_MUSIC);
		try {
			mp.setDataSource(url);
			mp.prepare();    // might take long! (for buffering, etc)
		} catch (IllegalArgumentException | SecurityException
				| IllegalStateException | IOException e) {
			e.printStackTrace();
		}
		
		mp.start();

		mp.setOnCompletionListener(new OnCompletionListener() {
		    @Override
		    public void onCompletion(MediaPlayer mp) {
		        onDone();
		    }
		 });
	   if ( mp.isPlaying() )
	     Toast.makeText(this, "Sound playback has started!", 
	    		                         Toast.LENGTH_LONG).show();
	}
	
	protected void onDone()
	{
       Toast.makeText(this, "Sound playback has finished!", Toast.LENGTH_LONG).show();
       mp.release();
       mp = null;
	}
}