package comm.client;

import android.app.Activity;

import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MainActivity extends Activity {
  private Socket socket;
  private static final int PORT_NO = 1989;
  // Need to change IP address to the IP of your server
  private static final String SERVER_IP = "192.168.1.69";
  //private static final String SERVER_IP = "10.0.2.2";
  @Override
  public void onCreate(Bundle savedInstanceState) {
	super.onCreate(savedInstanceState);
	setContentView(R.layout.activity_main);     
	new Thread(new ClientThread()).start();
  }

  public void onClick(View view) {
	try {
      EditText editText = (EditText) findViewById(R.id.EditText1);
      String str = editText.getText().toString();
      PrintWriter out = new PrintWriter(new BufferedWriter(
      new OutputStreamWriter(socket.getOutputStream())), true);
      out.println(str);
    } catch (UnknownHostException e) {
      e.printStackTrace();
	} catch (IOException e) {
	  e.printStackTrace();
	} catch (Exception e) {
	  e.printStackTrace();
	}
  }

  // inner class
  class ClientThread implements Runnable {
    @Override
    public void run() { 
	  try {
	    InetAddress serverAddr = InetAddress.getByName(SERVER_IP);
	    socket = new Socket(serverAddr, PORT_NO );
	  } catch (UnknownHostException e) {
	    e.printStackTrace();
	  } catch (IOException e) {
	    e.printStackTrace();
	  }
    }
  }
}  //class MainActivity
