package opengl.tetrahedron1;

import opengl.tetrahedron1.MyRenderer;
import android.app.Activity;
import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.view.MotionEvent;

public class MainActivity extends Activity 
{

  private GLSurfaceView glView;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    // Create a GLSurfaceView instance and set it
    // as the ContentView for this Activity.
    glView = new MyGLSurfaceView(this);
    setContentView(glView);
  }
}

class MyGLSurfaceView extends GLSurfaceView 
{
  private final MyRenderer renderer;

  public MyGLSurfaceView(Context context){
    super(context);
    // Create an OpenGL ES 2.0 context
    setEGLContextClientVersion ( 2 );

    // Set the Renderer for drawing on the GLSurfaceView
    renderer = new MyRenderer ( context );
    setRenderer( renderer );
    // Render the view only when there is a change in the drawing data
    setRenderMode(GLSurfaceView.RENDERMODE_WHEN_DIRTY);
  }
	 
  private final float TOUCH_SCALE_FACTOR = 180.0f / 320;
  private float previousX, previousY;
	  
  @Override
  public boolean onTouchEvent(MotionEvent e) {
    // MotionEvent reports input details from the touch screen
    // and other input controls. Here we are only interested
    // in events where the touch position has changed.

    float x = e.getX();
    float y = e.getY();       
    switch (e.getAction()) {
      case MotionEvent.ACTION_MOVE:
        float dx = x - previousX;
        float dy = y - previousY;
	                
        // reverse direction of rotation above the mid-line
        if (y > getHeight() / 2) 
          dx = dx * -1 ;            
        // reverse direction of rotation to left of the mid-line
        if (x < getWidth() / 2) 
          dy = dy * -1 ;
	                
        renderer.setAngle( renderer.getAngle() +
            ((dx + dy ) * TOUCH_SCALE_FACTOR));  // = 180.0f / 320
        requestRender();
    }
    previousX = x;
    previousY = y;
	   
    return true;
  }
}
