// MyRenderer.java
package opengl.tetrahedron;

import android.content.Context;
//import android.graphics.Matrix; not the right one
import android.opengl.Matrix;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class MyRenderer implements GLSurfaceView.Renderer 
{
  private final float[] mvpMatrix = new float[16];
  private final float[] projectionMatrix = new float[16];
  private final float[] viewMatrix = new float[16];

  private Tetrahedron tetrahedron;
  private Context context;

  public MyRenderer( Context context0 )
  {
     context = context0;
  }

  public void onSurfaceCreated(GL10 unused, EGLConfig config) {
    // Set the background frame color
    GLES20.glClearColor(0.9f, 0.9f, 0.9f, 1.0f);
    // construct a tetrahedron object
    tetrahedron = new Tetrahedron ( context );
  }

  public void onDrawFrame ( GL10 unused ) {
    // Redraw background color
    GLES20.glClear(GLES20.GL_COLOR_BUFFER_BIT);
    // Set the camera position (View matrix)
   Matrix.setLookAtM(viewMatrix, 0, 0.5f, 0, 4, 0f, 0f, 0f, 0f, 1.0f, 0.0f);

    // Calculate the product of projection and view transformation
    Matrix.multiplyMM(mvpMatrix, 0, projectionMatrix, 0, viewMatrix, 0);
    // Draw the tetrahedron with the resulted model-view projection matrix
    tetrahedron.draw( mvpMatrix );
  }

  public void onSurfaceChanged(GL10 unused, int width, int height) {
     GLES20.glViewport(0,  0, width,  width  );
     Matrix.frustumM( projectionMatrix, 0, -1, 1, -1, 1, 2, 10);
  }
}
