// MyRenderer.java
package opengl.glslsphere1;

import android.content.Context;
//import android.graphics.Matrix; not the right one
import android.opengl.Matrix;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class MyRenderer implements GLSurfaceView.Renderer 
{
  private final float[] mvpMatrix = new float[16];
  private final float[] projectionMatrix = new float[16];
  private final float[] viewMatrix = new float[16];
  private final float[] rvMatrix = new float[16];
  private float angle = 0;  // angle of rotation
  private Sphere sphere;
  private Context context;

  public MyRenderer( Context context0 )
  {
     context = context0;
  }

  public void onSurfaceCreated(GL10 unused, EGLConfig config) {
    // Set the background frame color
    GLES20.glClearColor(0.9f, 0.9f, 0.9f, 1.0f);
    // construct a triangle object
    //triangle = new Triangle( context );
    GLES20.glEnable(GLES20.GL_CULL_FACE);
    GLES20.glCullFace(GLES20.GL_BACK);
    GLES20.glFrontFace(GLES20.GL_CCW);
     
    GLES20.glEnable ( GLES20.GL_DEPTH_TEST );
    GLES20.glDepthFunc(GLES20.GL_GREATER);  //larger z values, nearer to viewpoint
 //   Matrix.frustumM( projectionMatrix, 0, -1, 1, -1, 1, 3, 20);
    sphere = new Sphere ( context );
  }

  public void onDrawFrame ( GL10 unused ) {
    // Redraw background color
    GLES20.glClear(GLES20.GL_COLOR_BUFFER_BIT | GLES20.GL_DEPTH_BUFFER_BIT);
    // Set the camera position (View matrix)
    Matrix.setLookAtM(viewMatrix, 0, 0.3f, 10f, 0.4f, 0f, 0f, 0f, 0f, 1.0f, 0.0f);

    Matrix.rotateM ( rvMatrix, 0, viewMatrix, 0, angle, 0.1f, 0.1f, 1f );
 
    // Calculate the projection and view transformation
    Matrix.multiplyMM(mvpMatrix, 0, projectionMatrix, 0, rvMatrix, 0);

    sphere.draw( mvpMatrix );
  }

  public void onSurfaceChanged(GL10 unused, int width, int height) {
     float ratio = (float) width / height;
     GLES20.glViewport(0,  0, width,  height  );
     Matrix.frustumM( projectionMatrix, 0, -ratio, ratio, -1, 1, 3, 50);
  }
  
  // Get and set angle of rotation 
  public float getAngle() {
      return angle;
  }

  public void setAngle(float angle0) {
      angle = angle0;
  }

}
