// MyRenderer.java
package opengl.glslsphere;

import android.content.Context;
import android.opengl.Matrix;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class MyRenderer implements GLSurfaceView.Renderer 
{
  private final float[] mvpMatrix = new float[16];
  private final float[] projectionMatrix = new float[16];
  private final float[] viewMatrix = new float[16];

  private Sphere sphere;
  private Context context;

  public MyRenderer( Context context0 )
  {
     context = context0;
  }

  public void onSurfaceCreated(GL10 unused, EGLConfig config) {
    // Set the background frame color
    GLES20.glClearColor(0.9f, 0.9f, 0.9f, 1.0f);;
    sphere = new Sphere ( context );
  }

  public void onDrawFrame ( GL10 unused ) {
    // Redraw background color
    GLES20.glClear(GLES20.GL_COLOR_BUFFER_BIT | GLES20.GL_DEPTH_BUFFER_BIT);
    // Set the camera position (View matrix)
    Matrix.setLookAtM(viewMatrix, 0, 0.3f, 10f, 0.4f, 0f, 0f, 0f, 0f, 1.0f, 0.0f);
    // Calculate the projection and view transformation
    Matrix.multiplyMM(mvpMatrix, 0, projectionMatrix, 0, viewMatrix, 0);

    sphere.draw( mvpMatrix );
  }

  public void onSurfaceChanged(GL10 unused, int width, int height) {
     float ratio = (float) width / height;
     GLES20.glViewport(0,  0, width,  height  );
     Matrix.frustumM( projectionMatrix, 0, -ratio, ratio, -1, 1, 3, 50);
  }
}
