package opengl.glslsphere;

import android.app.Activity;
import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Bundle;

public class MainActivity extends Activity {

  private GLSurfaceView glView;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    // Create a GLSurfaceView instance and set it
    // as the ContentView for this Activity.
    glView = new MyGLSurfaceView(this);
    setContentView(glView);
  }
}

class MyGLSurfaceView extends GLSurfaceView {
	  public MyGLSurfaceView(Context context){
	    super(context);
	    // Create an OpenGL ES 2.0 context
	    setEGLContextClientVersion ( 2 );
	    // Set the Renderer for drawing on the GLSurfaceView
	    
	    setRenderer(new MyRenderer( context ));
	    // Render the view only when there is a change in the drawing data
	    setRenderMode(GLSurfaceView.RENDERMODE_WHEN_DIRTY);
	  }
}