// MyRenderer.java
package opengl.glslanimate;

import android.content.Context;
import android.os.SystemClock;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class MyRenderer implements GLSurfaceView.Renderer {

  private Triangle triangle;
  private Context context;
  private long t0; 

  public MyRenderer( Context context0 )
  {
     context = context0;
  }

  public void onSurfaceCreated(GL10 unused, EGLConfig config) {
    // Set the background frame color
    GLES20.glClearColor(0.9f, 0.9f, 0.9f, 1.0f);
    // construct a triangle object
    triangle = new Triangle( context );
    t0 = SystemClock.elapsedRealtime();
  }

  public void onDrawFrame ( GL10 unused ) {
    // Redraw background color
    GLES20.glClear(GLES20.GL_COLOR_BUFFER_BIT);
    SystemClock.sleep ( 100 );  // delay 0.1 s
    long t = SystemClock.elapsedRealtime() - t0;
    triangle.draw( t );
  }

  public void onSurfaceChanged(GL10 unused, int width, int height) {
     GLES20.glViewport(0, 0, width, height);
  }
}
