// MyRenderer.java
package opengl.colorsquare;

import android.content.Context;
import android.os.SystemClock;
//import android.util.Log;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class MyRenderer implements GLSurfaceView.Renderer {

  private Square square;
  private Context context;
  private long t0; 

  public MyRenderer( Context context0 )
  {
     context = context0;
  }

  public void onSurfaceCreated(GL10 unused, EGLConfig config) {
    // Set the background frame color
    GLES20.glClearColor(0.9f, 0.9f, 0.9f, 1.0f);
    // construct a triangle object
    //triangle = new Triangle( context );
    square = new Square ( context );
    t0 = SystemClock.elapsedRealtime();
  }

  public void onDrawFrame ( GL10 unused ) {
    // Redraw background color
    GLES20.glClear(GLES20.GL_COLOR_BUFFER_BIT);
   
    square.draw();
  }

  public void onSurfaceChanged(GL10 unused, int width, int height) {
     float ratio = (float) width / height;
     GLES20.glViewport(0, height/3, width, (int) ( height*ratio) );
  }
}
