  package data.writefile;

  import java.io.FileInputStream;
  import java.io.FileOutputStream;
  import java.io.InputStreamReader;
  import java.io.OutputStreamWriter;
  import java.io.IOException;
  import android.app.Activity;
  import android.os.Bundle;
  import android.util.Log;
  import android.view.Menu;

  public class MainActivity extends Activity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
      super.onCreate(savedInstanceState);
      setContentView(R.layout.activity_main);
      try { 
        final String helloString = new String("Hello, Friend!");
        FileOutputStream fos = openFileOutput("sampleFile.txt",
                                                    MODE_WORLD_READABLE);
        OutputStreamWriter osw = new OutputStreamWriter( fos ); 

        // Write the string to the file
        osw.write ( helloString );
                       
        // Flush out anything in buffer
        osw.flush();  
        osw.close();
        // Read the file back...

        FileInputStream fis = openFileInput( "sampleFile.txt" );
        InputStreamReader isr = new InputStreamReader( fis );

        // Prepare a char-Array that to read data back
        char[] inputBuffer = new char[fis.available()];

        // Fill the Buffer with data from the file
        isr.read(inputBuffer);

        // Transform the chars to a String
        String readString = new String(inputBuffer);

        // Check if we read back the same chars that we had written out
        boolean writeReadEqual = helloString.equals ( readString );
        Log.i( "String read:", readString );
        Log.i( "File Reading:", "success = " + writeReadEqual );

      } catch (IOException ioe)  { ioe.printStackTrace(); }
    }
  }
