// VideoViewActivity.java
package video.videodemo1;

import android.media.MediaPlayer.OnPreparedListener;
import android.media.MediaPlayer;
import video.videodemo1.R;
import android.widget.*;
import android.app.*;
import android.net.Uri;
import android.util.Log;
import android.os.Bundle;

public class VideoViewActivity extends Activity 
{
  ProgressDialog progressDialog;
  VideoView videoView;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    // Get the layout from video_main.xml
    setContentView(R.layout.videoview_main);
    // Find your VideoView in video_main.xml layout
    videoView = (VideoView) findViewById(R.id.videoView);
    // Create a progressbar
    progressDialog = new ProgressDialog(VideoViewActivity.this);
    // Set progressbar title
    progressDialog.setTitle("Video Streaming");
    // Set progressbar message
    progressDialog.setMessage("Loading...");
    progressDialog.setIndeterminate ( false );
    progressDialog.setCancelable ( false );
    // Show progressbar
    progressDialog.show();

    try {
      // Create MediaController
      MediaController mediaController = new MediaController(VideoViewActivity.this);
      mediaController.setAnchorView(videoView);
      //Note: omit extension here though the real filename has it
      Uri video = Uri.parse ("android.resource://video.videodemo1/raw/android");
      videoView.setMediaController ( mediaController );
      videoView.setVideoURI(video);
    } catch (Exception e) {
      Log.e("Error", e.getMessage());
      e.printStackTrace();
    }
    videoView.requestFocus();
    videoView.setOnPreparedListener(new OnPreparedListener() {
    // Close the progress bar and play the video
    public void onPrepared(MediaPlayer mp) {
      progressDialog.dismiss();
      videoView.start();
    }
   });
  }
}